// Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub unsafe fn as_ptr(&self) -> *const T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut_ptr(&mut self) -> *mut T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
impl<T> ::std::clone::Clone for __IncompleteArrayField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
pub const __BITS_PER_LONG: u32 = 32;
pub const __FD_SETSIZE: u32 = 1024;
pub const _IOC_NRBITS: u32 = 8;
pub const _IOC_TYPEBITS: u32 = 8;
pub const _IOC_SIZEBITS: u32 = 14;
pub const _IOC_DIRBITS: u32 = 2;
pub const _IOC_NRMASK: u32 = 255;
pub const _IOC_TYPEMASK: u32 = 255;
pub const _IOC_SIZEMASK: u32 = 16383;
pub const _IOC_DIRMASK: u32 = 3;
pub const _IOC_NRSHIFT: u32 = 0;
pub const _IOC_TYPESHIFT: u32 = 8;
pub const _IOC_SIZESHIFT: u32 = 16;
pub const _IOC_DIRSHIFT: u32 = 30;
pub const _IOC_NONE: u32 = 0;
pub const _IOC_WRITE: u32 = 1;
pub const _IOC_READ: u32 = 2;
pub const IOC_IN: u32 = 1073741824;
pub const IOC_OUT: u32 = 2147483648;
pub const IOC_INOUT: u32 = 3221225472;
pub const IOCSIZE_MASK: u32 = 1073676288;
pub const IOCSIZE_SHIFT: u32 = 16;
pub const PSCI_0_2_FN_BASE: u32 = 2214592512;
pub const PSCI_0_2_64BIT: u32 = 1073741824;
pub const PSCI_0_2_FN64_BASE: u32 = 3288334336;
pub const PSCI_0_2_POWER_STATE_ID_MASK: u32 = 65535;
pub const PSCI_0_2_POWER_STATE_ID_SHIFT: u32 = 0;
pub const PSCI_0_2_POWER_STATE_TYPE_SHIFT: u32 = 16;
pub const PSCI_0_2_POWER_STATE_TYPE_MASK: u32 = 65536;
pub const PSCI_0_2_POWER_STATE_AFFL_SHIFT: u32 = 24;
pub const PSCI_0_2_POWER_STATE_AFFL_MASK: u32 = 50331648;
pub const PSCI_1_0_EXT_POWER_STATE_ID_MASK: u32 = 268435455;
pub const PSCI_1_0_EXT_POWER_STATE_ID_SHIFT: u32 = 0;
pub const PSCI_1_0_EXT_POWER_STATE_TYPE_SHIFT: u32 = 30;
pub const PSCI_1_0_EXT_POWER_STATE_TYPE_MASK: u32 = 1073741824;
pub const PSCI_0_2_AFFINITY_LEVEL_ON: u32 = 0;
pub const PSCI_0_2_AFFINITY_LEVEL_OFF: u32 = 1;
pub const PSCI_0_2_AFFINITY_LEVEL_ON_PENDING: u32 = 2;
pub const PSCI_0_2_TOS_UP_MIGRATE: u32 = 0;
pub const PSCI_0_2_TOS_UP_NO_MIGRATE: u32 = 1;
pub const PSCI_0_2_TOS_MP: u32 = 2;
pub const PSCI_VERSION_MAJOR_SHIFT: u32 = 16;
pub const PSCI_VERSION_MINOR_MASK: u32 = 65535;
pub const PSCI_VERSION_MAJOR_MASK: i32 = -65536;
pub const PSCI_1_0_FEATURES_CPU_SUSPEND_PF_SHIFT: u32 = 1;
pub const PSCI_1_0_FEATURES_CPU_SUSPEND_PF_MASK: u32 = 2;
pub const PSCI_RET_SUCCESS: u32 = 0;
pub const PSCI_RET_NOT_SUPPORTED: i32 = -1;
pub const PSCI_RET_INVALID_PARAMS: i32 = -2;
pub const PSCI_RET_DENIED: i32 = -3;
pub const PSCI_RET_ALREADY_ON: i32 = -4;
pub const PSCI_RET_ON_PENDING: i32 = -5;
pub const PSCI_RET_INTERNAL_FAILURE: i32 = -6;
pub const PSCI_RET_NOT_PRESENT: i32 = -7;
pub const PSCI_RET_DISABLED: i32 = -8;
pub const PSCI_RET_INVALID_ADDRESS: i32 = -9;
pub const HWCAP_SWP: u32 = 1;
pub const HWCAP_HALF: u32 = 2;
pub const HWCAP_THUMB: u32 = 4;
pub const HWCAP_26BIT: u32 = 8;
pub const HWCAP_FAST_MULT: u32 = 16;
pub const HWCAP_FPA: u32 = 32;
pub const HWCAP_VFP: u32 = 64;
pub const HWCAP_EDSP: u32 = 128;
pub const HWCAP_JAVA: u32 = 256;
pub const HWCAP_IWMMXT: u32 = 512;
pub const HWCAP_CRUNCH: u32 = 1024;
pub const HWCAP_THUMBEE: u32 = 2048;
pub const HWCAP_NEON: u32 = 4096;
pub const HWCAP_VFPv3: u32 = 8192;
pub const HWCAP_VFPv3D16: u32 = 16384;
pub const HWCAP_TLS: u32 = 32768;
pub const HWCAP_VFPv4: u32 = 65536;
pub const HWCAP_IDIVA: u32 = 131072;
pub const HWCAP_IDIVT: u32 = 262144;
pub const HWCAP_VFPD32: u32 = 524288;
pub const HWCAP_IDIV: u32 = 393216;
pub const HWCAP_LPAE: u32 = 1048576;
pub const HWCAP_EVTSTRM: u32 = 2097152;
pub const HWCAP2_AES: u32 = 1;
pub const HWCAP2_PMULL: u32 = 2;
pub const HWCAP2_SHA1: u32 = 4;
pub const HWCAP2_SHA2: u32 = 8;
pub const HWCAP2_CRC32: u32 = 16;
pub const PTRACE_GETREGS: u32 = 12;
pub const PTRACE_SETREGS: u32 = 13;
pub const PTRACE_GETFPREGS: u32 = 14;
pub const PTRACE_SETFPREGS: u32 = 15;
pub const PTRACE_GETWMMXREGS: u32 = 18;
pub const PTRACE_SETWMMXREGS: u32 = 19;
pub const PTRACE_OLDSETOPTIONS: u32 = 21;
pub const PTRACE_GET_THREAD_AREA: u32 = 22;
pub const PTRACE_SET_SYSCALL: u32 = 23;
pub const PTRACE_GETCRUNCHREGS: u32 = 25;
pub const PTRACE_SETCRUNCHREGS: u32 = 26;
pub const PTRACE_GETVFPREGS: u32 = 27;
pub const PTRACE_SETVFPREGS: u32 = 28;
pub const PTRACE_GETHBPREGS: u32 = 29;
pub const PTRACE_SETHBPREGS: u32 = 30;
pub const PTRACE_GETFDPIC: u32 = 31;
pub const PTRACE_GETFDPIC_EXEC: u32 = 0;
pub const PTRACE_GETFDPIC_INTERP: u32 = 1;
pub const USR26_MODE: u32 = 0;
pub const FIQ26_MODE: u32 = 1;
pub const IRQ26_MODE: u32 = 2;
pub const SVC26_MODE: u32 = 3;
pub const USR_MODE: u32 = 16;
pub const SVC_MODE: u32 = 19;
pub const FIQ_MODE: u32 = 17;
pub const IRQ_MODE: u32 = 18;
pub const MON_MODE: u32 = 22;
pub const ABT_MODE: u32 = 23;
pub const HYP_MODE: u32 = 26;
pub const UND_MODE: u32 = 27;
pub const SYSTEM_MODE: u32 = 31;
pub const MODE32_BIT: u32 = 16;
pub const MODE_MASK: u32 = 31;
pub const V4_PSR_T_BIT: u32 = 32;
pub const V7M_PSR_T_BIT: u32 = 16777216;
pub const PSR_T_BIT: u32 = 32;
pub const PSR_F_BIT: u32 = 64;
pub const PSR_I_BIT: u32 = 128;
pub const PSR_A_BIT: u32 = 256;
pub const PSR_E_BIT: u32 = 512;
pub const PSR_J_BIT: u32 = 16777216;
pub const PSR_Q_BIT: u32 = 134217728;
pub const PSR_V_BIT: u32 = 268435456;
pub const PSR_C_BIT: u32 = 536870912;
pub const PSR_Z_BIT: u32 = 1073741824;
pub const PSR_N_BIT: u32 = 2147483648;
pub const PSR_f: u32 = 4278190080;
pub const PSR_s: u32 = 16711680;
pub const PSR_x: u32 = 65280;
pub const PSR_c: u32 = 255;
pub const APSR_MASK: u32 = 4161732608;
pub const PSR_ISET_MASK: u32 = 16777232;
pub const PSR_IT_MASK: u32 = 100727808;
pub const PSR_ENDIAN_MASK: u32 = 512;
pub const PSR_ENDSTATE: u32 = 0;
pub const PT_TEXT_ADDR: u32 = 65536;
pub const PT_DATA_ADDR: u32 = 65540;
pub const PT_TEXT_END_ADDR: u32 = 65544;
pub const ARM_VFPREGS_SIZE: u32 = 260;
pub const KVM_COALESCED_MMIO_PAGE_OFFSET: u32 = 1;
pub const KVM_ARM_TARGET_CORTEX_A15: u32 = 0;
pub const KVM_ARM_TARGET_CORTEX_A7: u32 = 1;
pub const KVM_ARM_NUM_TARGETS: u32 = 2;
pub const KVM_ARM_DEVICE_TYPE_SHIFT: u32 = 0;
pub const KVM_ARM_DEVICE_TYPE_MASK: u32 = 65535;
pub const KVM_ARM_DEVICE_ID_SHIFT: u32 = 16;
pub const KVM_ARM_DEVICE_ID_MASK: u32 = 4294901760;
pub const KVM_ARM_DEVICE_VGIC_V2: u32 = 0;
pub const KVM_VGIC_V2_ADDR_TYPE_DIST: u32 = 0;
pub const KVM_VGIC_V2_ADDR_TYPE_CPU: u32 = 1;
pub const KVM_VGIC_V2_DIST_SIZE: u32 = 4096;
pub const KVM_VGIC_V2_CPU_SIZE: u32 = 8192;
pub const KVM_VGIC_V3_ADDR_TYPE_DIST: u32 = 2;
pub const KVM_VGIC_V3_ADDR_TYPE_REDIST: u32 = 3;
pub const KVM_VGIC_ITS_ADDR_TYPE: u32 = 4;
pub const KVM_VGIC_V3_ADDR_TYPE_REDIST_REGION: u32 = 5;
pub const KVM_ARM_VCPU_POWER_OFF: u32 = 0;
pub const KVM_ARM_VCPU_PSCI_0_2: u32 = 1;
pub const KVM_REG_ARM_COPROC_MASK: u32 = 268369920;
pub const KVM_REG_ARM_COPROC_SHIFT: u32 = 16;
pub const KVM_REG_ARM_32_OPC2_MASK: u32 = 7;
pub const KVM_REG_ARM_32_OPC2_SHIFT: u32 = 0;
pub const KVM_REG_ARM_OPC1_MASK: u32 = 120;
pub const KVM_REG_ARM_OPC1_SHIFT: u32 = 3;
pub const KVM_REG_ARM_CRM_MASK: u32 = 1920;
pub const KVM_REG_ARM_CRM_SHIFT: u32 = 7;
pub const KVM_REG_ARM_32_CRN_MASK: u32 = 30720;
pub const KVM_REG_ARM_32_CRN_SHIFT: u32 = 11;
pub const KVM_REG_ARM_SECURE_MASK: u32 = 268435456;
pub const KVM_REG_ARM_SECURE_SHIFT: u32 = 28;
pub const KVM_REG_ARM_CORE: u32 = 1048576;
pub const KVM_REG_ARM_DEMUX: u32 = 1114112;
pub const KVM_REG_ARM_DEMUX_ID_MASK: u32 = 65280;
pub const KVM_REG_ARM_DEMUX_ID_SHIFT: u32 = 8;
pub const KVM_REG_ARM_DEMUX_ID_CCSIDR: u32 = 0;
pub const KVM_REG_ARM_DEMUX_VAL_MASK: u32 = 255;
pub const KVM_REG_ARM_DEMUX_VAL_SHIFT: u32 = 0;
pub const KVM_REG_ARM_VFP: u32 = 1179648;
pub const KVM_REG_ARM_VFP_MASK: u32 = 65535;
pub const KVM_REG_ARM_VFP_BASE_REG: u32 = 0;
pub const KVM_REG_ARM_VFP_FPSID: u32 = 4096;
pub const KVM_REG_ARM_VFP_FPSCR: u32 = 4097;
pub const KVM_REG_ARM_VFP_MVFR1: u32 = 4102;
pub const KVM_REG_ARM_VFP_MVFR0: u32 = 4103;
pub const KVM_REG_ARM_VFP_FPEXC: u32 = 4104;
pub const KVM_REG_ARM_VFP_FPINST: u32 = 4105;
pub const KVM_REG_ARM_VFP_FPINST2: u32 = 4106;
pub const KVM_REG_ARM_FW: u32 = 1310720;
pub const KVM_DEV_ARM_VGIC_GRP_ADDR: u32 = 0;
pub const KVM_DEV_ARM_VGIC_GRP_DIST_REGS: u32 = 1;
pub const KVM_DEV_ARM_VGIC_GRP_CPU_REGS: u32 = 2;
pub const KVM_DEV_ARM_VGIC_CPUID_SHIFT: u32 = 32;
pub const KVM_DEV_ARM_VGIC_CPUID_MASK: u64 = 1095216660480;
pub const KVM_DEV_ARM_VGIC_V3_MPIDR_SHIFT: u32 = 32;
pub const KVM_DEV_ARM_VGIC_V3_MPIDR_MASK: i64 = -4294967296;
pub const KVM_DEV_ARM_VGIC_OFFSET_SHIFT: u32 = 0;
pub const KVM_DEV_ARM_VGIC_OFFSET_MASK: u32 = 4294967295;
pub const KVM_DEV_ARM_VGIC_SYSREG_INSTR_MASK: u32 = 65535;
pub const KVM_DEV_ARM_VGIC_GRP_NR_IRQS: u32 = 3;
pub const KVM_DEV_ARM_VGIC_GRP_CTRL: u32 = 4;
pub const KVM_DEV_ARM_VGIC_GRP_REDIST_REGS: u32 = 5;
pub const KVM_DEV_ARM_VGIC_GRP_CPU_SYSREGS: u32 = 6;
pub const KVM_DEV_ARM_VGIC_GRP_LEVEL_INFO: u32 = 7;
pub const KVM_DEV_ARM_VGIC_GRP_ITS_REGS: u32 = 8;
pub const KVM_DEV_ARM_VGIC_LINE_LEVEL_INFO_SHIFT: u32 = 10;
pub const KVM_DEV_ARM_VGIC_LINE_LEVEL_INFO_MASK: u32 = 4294966272;
pub const KVM_DEV_ARM_VGIC_LINE_LEVEL_INTID_MASK: u32 = 1023;
pub const VGIC_LEVEL_INFO_LINE_LEVEL: u32 = 0;
pub const KVM_ARM_VCPU_PMU_V3_CTRL: u32 = 0;
pub const KVM_ARM_VCPU_PMU_V3_IRQ: u32 = 0;
pub const KVM_ARM_VCPU_PMU_V3_INIT: u32 = 1;
pub const KVM_ARM_VCPU_TIMER_CTRL: u32 = 1;
pub const KVM_ARM_VCPU_TIMER_IRQ_VTIMER: u32 = 0;
pub const KVM_ARM_VCPU_TIMER_IRQ_PTIMER: u32 = 1;
pub const KVM_DEV_ARM_VGIC_CTRL_INIT: u32 = 0;
pub const KVM_DEV_ARM_ITS_SAVE_TABLES: u32 = 1;
pub const KVM_DEV_ARM_ITS_RESTORE_TABLES: u32 = 2;
pub const KVM_DEV_ARM_VGIC_SAVE_PENDING_TABLES: u32 = 3;
pub const KVM_DEV_ARM_ITS_CTRL_RESET: u32 = 4;
pub const KVM_ARM_IRQ_TYPE_SHIFT: u32 = 24;
pub const KVM_ARM_IRQ_TYPE_MASK: u32 = 255;
pub const KVM_ARM_IRQ_VCPU_SHIFT: u32 = 16;
pub const KVM_ARM_IRQ_VCPU_MASK: u32 = 255;
pub const KVM_ARM_IRQ_NUM_SHIFT: u32 = 0;
pub const KVM_ARM_IRQ_NUM_MASK: u32 = 65535;
pub const KVM_ARM_IRQ_TYPE_CPU: u32 = 0;
pub const KVM_ARM_IRQ_TYPE_SPI: u32 = 1;
pub const KVM_ARM_IRQ_TYPE_PPI: u32 = 2;
pub const KVM_ARM_IRQ_CPU_IRQ: u32 = 0;
pub const KVM_ARM_IRQ_CPU_FIQ: u32 = 1;
pub const KVM_ARM_IRQ_GIC_MAX: u32 = 127;
pub const KVM_NR_IRQCHIPS: u32 = 1;
pub const KVM_PSCI_FN_BASE: u32 = 2512501342;
pub const KVM_PSCI_RET_SUCCESS: u32 = 0;
pub const KVM_PSCI_RET_NI: i32 = -1;
pub const KVM_PSCI_RET_INVAL: i32 = -2;
pub const KVM_PSCI_RET_DENIED: i32 = -3;
pub const KVM_API_VERSION: u32 = 12;
pub const KVM_TRC_SHIFT: u32 = 16;
pub const KVM_TRC_ENTRYEXIT: u32 = 65536;
pub const KVM_TRC_HANDLER: u32 = 131072;
pub const KVM_TRC_VMENTRY: u32 = 65537;
pub const KVM_TRC_VMEXIT: u32 = 65538;
pub const KVM_TRC_PAGE_FAULT: u32 = 131073;
pub const KVM_TRC_HEAD_SIZE: u32 = 12;
pub const KVM_TRC_CYCLE_SIZE: u32 = 8;
pub const KVM_TRC_EXTRA_MAX: u32 = 7;
pub const KVM_TRC_INJ_VIRQ: u32 = 131074;
pub const KVM_TRC_REDELIVER_EVT: u32 = 131075;
pub const KVM_TRC_PEND_INTR: u32 = 131076;
pub const KVM_TRC_IO_READ: u32 = 131077;
pub const KVM_TRC_IO_WRITE: u32 = 131078;
pub const KVM_TRC_CR_READ: u32 = 131079;
pub const KVM_TRC_CR_WRITE: u32 = 131080;
pub const KVM_TRC_DR_READ: u32 = 131081;
pub const KVM_TRC_DR_WRITE: u32 = 131082;
pub const KVM_TRC_MSR_READ: u32 = 131083;
pub const KVM_TRC_MSR_WRITE: u32 = 131084;
pub const KVM_TRC_CPUID: u32 = 131085;
pub const KVM_TRC_INTR: u32 = 131086;
pub const KVM_TRC_NMI: u32 = 131087;
pub const KVM_TRC_VMMCALL: u32 = 131088;
pub const KVM_TRC_HLT: u32 = 131089;
pub const KVM_TRC_CLTS: u32 = 131090;
pub const KVM_TRC_LMSW: u32 = 131091;
pub const KVM_TRC_APIC_ACCESS: u32 = 131092;
pub const KVM_TRC_TDP_FAULT: u32 = 131093;
pub const KVM_TRC_GTLB_WRITE: u32 = 131094;
pub const KVM_TRC_STLB_WRITE: u32 = 131095;
pub const KVM_TRC_STLB_INVAL: u32 = 131096;
pub const KVM_TRC_PPC_INSTR: u32 = 131097;
pub const KVM_MEM_LOG_DIRTY_PAGES: u32 = 1;
pub const KVM_MEM_READONLY: u32 = 2;
pub const KVM_PIT_SPEAKER_DUMMY: u32 = 1;
pub const KVM_S390_CMMA_PEEK: u32 = 1;
pub const KVM_EXIT_HYPERV_SYNIC: u32 = 1;
pub const KVM_EXIT_HYPERV_HCALL: u32 = 2;
pub const KVM_S390_GET_SKEYS_NONE: u32 = 1;
pub const KVM_S390_SKEYS_MAX: u32 = 1048576;
pub const KVM_EXIT_UNKNOWN: u32 = 0;
pub const KVM_EXIT_EXCEPTION: u32 = 1;
pub const KVM_EXIT_IO: u32 = 2;
pub const KVM_EXIT_HYPERCALL: u32 = 3;
pub const KVM_EXIT_DEBUG: u32 = 4;
pub const KVM_EXIT_HLT: u32 = 5;
pub const KVM_EXIT_MMIO: u32 = 6;
pub const KVM_EXIT_IRQ_WINDOW_OPEN: u32 = 7;
pub const KVM_EXIT_SHUTDOWN: u32 = 8;
pub const KVM_EXIT_FAIL_ENTRY: u32 = 9;
pub const KVM_EXIT_INTR: u32 = 10;
pub const KVM_EXIT_SET_TPR: u32 = 11;
pub const KVM_EXIT_TPR_ACCESS: u32 = 12;
pub const KVM_EXIT_S390_SIEIC: u32 = 13;
pub const KVM_EXIT_S390_RESET: u32 = 14;
pub const KVM_EXIT_DCR: u32 = 15;
pub const KVM_EXIT_NMI: u32 = 16;
pub const KVM_EXIT_INTERNAL_ERROR: u32 = 17;
pub const KVM_EXIT_OSI: u32 = 18;
pub const KVM_EXIT_PAPR_HCALL: u32 = 19;
pub const KVM_EXIT_S390_UCONTROL: u32 = 20;
pub const KVM_EXIT_WATCHDOG: u32 = 21;
pub const KVM_EXIT_S390_TSCH: u32 = 22;
pub const KVM_EXIT_EPR: u32 = 23;
pub const KVM_EXIT_SYSTEM_EVENT: u32 = 24;
pub const KVM_EXIT_S390_STSI: u32 = 25;
pub const KVM_EXIT_IOAPIC_EOI: u32 = 26;
pub const KVM_EXIT_HYPERV: u32 = 27;
pub const KVM_INTERNAL_ERROR_EMULATION: u32 = 1;
pub const KVM_INTERNAL_ERROR_SIMUL_EX: u32 = 2;
pub const KVM_INTERNAL_ERROR_DELIVERY_EV: u32 = 3;
pub const KVM_EXIT_IO_IN: u32 = 0;
pub const KVM_EXIT_IO_OUT: u32 = 1;
pub const KVM_S390_RESET_POR: u32 = 1;
pub const KVM_S390_RESET_CLEAR: u32 = 2;
pub const KVM_S390_RESET_SUBSYSTEM: u32 = 4;
pub const KVM_S390_RESET_CPU_INIT: u32 = 8;
pub const KVM_S390_RESET_IPL: u32 = 16;
pub const KVM_SYSTEM_EVENT_SHUTDOWN: u32 = 1;
pub const KVM_SYSTEM_EVENT_RESET: u32 = 2;
pub const KVM_SYSTEM_EVENT_CRASH: u32 = 3;
pub const SYNC_REGS_SIZE_BYTES: u32 = 2048;
pub const KVM_S390_MEMOP_LOGICAL_READ: u32 = 0;
pub const KVM_S390_MEMOP_LOGICAL_WRITE: u32 = 1;
pub const KVM_S390_MEMOP_F_CHECK_ONLY: u32 = 1;
pub const KVM_S390_MEMOP_F_INJECT_EXCEPTION: u32 = 2;
pub const KVM_MP_STATE_RUNNABLE: u32 = 0;
pub const KVM_MP_STATE_UNINITIALIZED: u32 = 1;
pub const KVM_MP_STATE_INIT_RECEIVED: u32 = 2;
pub const KVM_MP_STATE_HALTED: u32 = 3;
pub const KVM_MP_STATE_SIPI_RECEIVED: u32 = 4;
pub const KVM_MP_STATE_STOPPED: u32 = 5;
pub const KVM_MP_STATE_CHECK_STOP: u32 = 6;
pub const KVM_MP_STATE_OPERATING: u32 = 7;
pub const KVM_MP_STATE_LOAD: u32 = 8;
pub const KVM_S390_SIGP_STOP: u32 = 4294836224;
pub const KVM_S390_PROGRAM_INT: u32 = 4294836225;
pub const KVM_S390_SIGP_SET_PREFIX: u32 = 4294836226;
pub const KVM_S390_RESTART: u32 = 4294836227;
pub const KVM_S390_INT_PFAULT_INIT: u32 = 4294836228;
pub const KVM_S390_INT_PFAULT_DONE: u32 = 4294836229;
pub const KVM_S390_MCHK: u32 = 4294840320;
pub const KVM_S390_INT_CLOCK_COMP: u32 = 4294905860;
pub const KVM_S390_INT_CPU_TIMER: u32 = 4294905861;
pub const KVM_S390_INT_VIRTIO: u32 = 4294911491;
pub const KVM_S390_INT_SERVICE: u32 = 4294910977;
pub const KVM_S390_INT_EMERGENCY: u32 = 4294906369;
pub const KVM_S390_INT_EXTERNAL_CALL: u32 = 4294906370;
pub const KVM_S390_INT_IO_MIN: u32 = 0;
pub const KVM_S390_INT_IO_MAX: u32 = 4294836223;
pub const KVM_S390_INT_IO_AI_MASK: u32 = 67108864;
pub const KVM_S390_PGM_FLAGS_ILC_VALID: u32 = 1;
pub const KVM_S390_PGM_FLAGS_ILC_0: u32 = 2;
pub const KVM_S390_PGM_FLAGS_ILC_1: u32 = 4;
pub const KVM_S390_PGM_FLAGS_ILC_MASK: u32 = 6;
pub const KVM_S390_PGM_FLAGS_NO_REWIND: u32 = 8;
pub const KVM_S390_STOP_FLAG_STORE_STATUS: u32 = 1;
pub const KVM_GUESTDBG_ENABLE: u32 = 1;
pub const KVM_GUESTDBG_SINGLESTEP: u32 = 2;
pub const KVM_X86_DISABLE_EXITS_MWAIT: u32 = 1;
pub const KVM_X86_DISABLE_EXITS_HLT: u32 = 2;
pub const KVM_X86_DISABLE_EXITS_PAUSE: u32 = 4;
pub const KVM_X86_DISABLE_VALID_EXITS: u32 = 7;
pub const KVM_PPC_PVINFO_FLAGS_EV_IDLE: u32 = 1;
pub const KVM_PPC_PAGE_SIZES_MAX_SZ: u32 = 8;
pub const KVM_PPC_PAGE_SIZES_REAL: u32 = 1;
pub const KVM_PPC_1T_SEGMENTS: u32 = 2;
pub const KVM_PPC_NO_HASH: u32 = 4;
pub const KVMIO: u32 = 174;
pub const KVM_VM_S390_UCONTROL: u32 = 1;
pub const KVM_VM_PPC_HV: u32 = 1;
pub const KVM_VM_PPC_PR: u32 = 2;
pub const KVM_VM_MIPS_TE: u32 = 0;
pub const KVM_VM_MIPS_VZ: u32 = 1;
pub const KVM_S390_SIE_PAGE_OFFSET: u32 = 1;
pub const KVM_VM_TYPE_ARM_IPA_SIZE_MASK: u32 = 255;
pub const KVM_CAP_IRQCHIP: u32 = 0;
pub const KVM_CAP_HLT: u32 = 1;
pub const KVM_CAP_MMU_SHADOW_CACHE_CONTROL: u32 = 2;
pub const KVM_CAP_USER_MEMORY: u32 = 3;
pub const KVM_CAP_SET_TSS_ADDR: u32 = 4;
pub const KVM_CAP_VAPIC: u32 = 6;
pub const KVM_CAP_EXT_CPUID: u32 = 7;
pub const KVM_CAP_CLOCKSOURCE: u32 = 8;
pub const KVM_CAP_NR_VCPUS: u32 = 9;
pub const KVM_CAP_NR_MEMSLOTS: u32 = 10;
pub const KVM_CAP_PIT: u32 = 11;
pub const KVM_CAP_NOP_IO_DELAY: u32 = 12;
pub const KVM_CAP_PV_MMU: u32 = 13;
pub const KVM_CAP_MP_STATE: u32 = 14;
pub const KVM_CAP_COALESCED_MMIO: u32 = 15;
pub const KVM_CAP_SYNC_MMU: u32 = 16;
pub const KVM_CAP_IOMMU: u32 = 18;
pub const KVM_CAP_DESTROY_MEMORY_REGION_WORKS: u32 = 21;
pub const KVM_CAP_USER_NMI: u32 = 22;
pub const KVM_CAP_SET_GUEST_DEBUG: u32 = 23;
pub const KVM_CAP_IRQ_ROUTING: u32 = 25;
pub const KVM_CAP_IRQ_INJECT_STATUS: u32 = 26;
pub const KVM_CAP_ASSIGN_DEV_IRQ: u32 = 29;
pub const KVM_CAP_JOIN_MEMORY_REGIONS_WORKS: u32 = 30;
pub const KVM_CAP_IRQFD: u32 = 32;
pub const KVM_CAP_SET_BOOT_CPU_ID: u32 = 34;
pub const KVM_CAP_IOEVENTFD: u32 = 36;
pub const KVM_CAP_SET_IDENTITY_MAP_ADDR: u32 = 37;
pub const KVM_CAP_ADJUST_CLOCK: u32 = 39;
pub const KVM_CAP_INTERNAL_ERROR_DATA: u32 = 40;
pub const KVM_CAP_VCPU_EVENTS: u32 = 41;
pub const KVM_CAP_S390_PSW: u32 = 42;
pub const KVM_CAP_PPC_SEGSTATE: u32 = 43;
pub const KVM_CAP_HYPERV: u32 = 44;
pub const KVM_CAP_HYPERV_VAPIC: u32 = 45;
pub const KVM_CAP_HYPERV_SPIN: u32 = 46;
pub const KVM_CAP_PCI_SEGMENT: u32 = 47;
pub const KVM_CAP_PPC_PAIRED_SINGLES: u32 = 48;
pub const KVM_CAP_INTR_SHADOW: u32 = 49;
pub const KVM_CAP_X86_ROBUST_SINGLESTEP: u32 = 51;
pub const KVM_CAP_PPC_OSI: u32 = 52;
pub const KVM_CAP_PPC_UNSET_IRQ: u32 = 53;
pub const KVM_CAP_ENABLE_CAP: u32 = 54;
pub const KVM_CAP_PPC_GET_PVINFO: u32 = 57;
pub const KVM_CAP_PPC_IRQ_LEVEL: u32 = 58;
pub const KVM_CAP_ASYNC_PF: u32 = 59;
pub const KVM_CAP_TSC_CONTROL: u32 = 60;
pub const KVM_CAP_GET_TSC_KHZ: u32 = 61;
pub const KVM_CAP_PPC_BOOKE_SREGS: u32 = 62;
pub const KVM_CAP_SPAPR_TCE: u32 = 63;
pub const KVM_CAP_PPC_SMT: u32 = 64;
pub const KVM_CAP_PPC_RMA: u32 = 65;
pub const KVM_CAP_MAX_VCPUS: u32 = 66;
pub const KVM_CAP_PPC_HIOR: u32 = 67;
pub const KVM_CAP_PPC_PAPR: u32 = 68;
pub const KVM_CAP_SW_TLB: u32 = 69;
pub const KVM_CAP_ONE_REG: u32 = 70;
pub const KVM_CAP_S390_GMAP: u32 = 71;
pub const KVM_CAP_TSC_DEADLINE_TIMER: u32 = 72;
pub const KVM_CAP_S390_UCONTROL: u32 = 73;
pub const KVM_CAP_SYNC_REGS: u32 = 74;
pub const KVM_CAP_PCI_2_3: u32 = 75;
pub const KVM_CAP_KVMCLOCK_CTRL: u32 = 76;
pub const KVM_CAP_SIGNAL_MSI: u32 = 77;
pub const KVM_CAP_PPC_GET_SMMU_INFO: u32 = 78;
pub const KVM_CAP_S390_COW: u32 = 79;
pub const KVM_CAP_PPC_ALLOC_HTAB: u32 = 80;
pub const KVM_CAP_READONLY_MEM: u32 = 81;
pub const KVM_CAP_IRQFD_RESAMPLE: u32 = 82;
pub const KVM_CAP_PPC_BOOKE_WATCHDOG: u32 = 83;
pub const KVM_CAP_PPC_HTAB_FD: u32 = 84;
pub const KVM_CAP_S390_CSS_SUPPORT: u32 = 85;
pub const KVM_CAP_PPC_EPR: u32 = 86;
pub const KVM_CAP_ARM_PSCI: u32 = 87;
pub const KVM_CAP_ARM_SET_DEVICE_ADDR: u32 = 88;
pub const KVM_CAP_DEVICE_CTRL: u32 = 89;
pub const KVM_CAP_IRQ_MPIC: u32 = 90;
pub const KVM_CAP_PPC_RTAS: u32 = 91;
pub const KVM_CAP_IRQ_XICS: u32 = 92;
pub const KVM_CAP_ARM_EL1_32BIT: u32 = 93;
pub const KVM_CAP_SPAPR_MULTITCE: u32 = 94;
pub const KVM_CAP_EXT_EMUL_CPUID: u32 = 95;
pub const KVM_CAP_HYPERV_TIME: u32 = 96;
pub const KVM_CAP_IOAPIC_POLARITY_IGNORED: u32 = 97;
pub const KVM_CAP_ENABLE_CAP_VM: u32 = 98;
pub const KVM_CAP_S390_IRQCHIP: u32 = 99;
pub const KVM_CAP_IOEVENTFD_NO_LENGTH: u32 = 100;
pub const KVM_CAP_VM_ATTRIBUTES: u32 = 101;
pub const KVM_CAP_ARM_PSCI_0_2: u32 = 102;
pub const KVM_CAP_PPC_FIXUP_HCALL: u32 = 103;
pub const KVM_CAP_PPC_ENABLE_HCALL: u32 = 104;
pub const KVM_CAP_CHECK_EXTENSION_VM: u32 = 105;
pub const KVM_CAP_S390_USER_SIGP: u32 = 106;
pub const KVM_CAP_S390_VECTOR_REGISTERS: u32 = 107;
pub const KVM_CAP_S390_MEM_OP: u32 = 108;
pub const KVM_CAP_S390_USER_STSI: u32 = 109;
pub const KVM_CAP_S390_SKEYS: u32 = 110;
pub const KVM_CAP_MIPS_FPU: u32 = 111;
pub const KVM_CAP_MIPS_MSA: u32 = 112;
pub const KVM_CAP_S390_INJECT_IRQ: u32 = 113;
pub const KVM_CAP_S390_IRQ_STATE: u32 = 114;
pub const KVM_CAP_PPC_HWRNG: u32 = 115;
pub const KVM_CAP_DISABLE_QUIRKS: u32 = 116;
pub const KVM_CAP_X86_SMM: u32 = 117;
pub const KVM_CAP_MULTI_ADDRESS_SPACE: u32 = 118;
pub const KVM_CAP_GUEST_DEBUG_HW_BPS: u32 = 119;
pub const KVM_CAP_GUEST_DEBUG_HW_WPS: u32 = 120;
pub const KVM_CAP_SPLIT_IRQCHIP: u32 = 121;
pub const KVM_CAP_IOEVENTFD_ANY_LENGTH: u32 = 122;
pub const KVM_CAP_HYPERV_SYNIC: u32 = 123;
pub const KVM_CAP_S390_RI: u32 = 124;
pub const KVM_CAP_SPAPR_TCE_64: u32 = 125;
pub const KVM_CAP_ARM_PMU_V3: u32 = 126;
pub const KVM_CAP_VCPU_ATTRIBUTES: u32 = 127;
pub const KVM_CAP_MAX_VCPU_ID: u32 = 128;
pub const KVM_CAP_X2APIC_API: u32 = 129;
pub const KVM_CAP_S390_USER_INSTR0: u32 = 130;
pub const KVM_CAP_MSI_DEVID: u32 = 131;
pub const KVM_CAP_PPC_HTM: u32 = 132;
pub const KVM_CAP_SPAPR_RESIZE_HPT: u32 = 133;
pub const KVM_CAP_PPC_MMU_RADIX: u32 = 134;
pub const KVM_CAP_PPC_MMU_HASH_V3: u32 = 135;
pub const KVM_CAP_IMMEDIATE_EXIT: u32 = 136;
pub const KVM_CAP_MIPS_VZ: u32 = 137;
pub const KVM_CAP_MIPS_TE: u32 = 138;
pub const KVM_CAP_MIPS_64BIT: u32 = 139;
pub const KVM_CAP_S390_GS: u32 = 140;
pub const KVM_CAP_S390_AIS: u32 = 141;
pub const KVM_CAP_SPAPR_TCE_VFIO: u32 = 142;
pub const KVM_CAP_X86_DISABLE_EXITS: u32 = 143;
pub const KVM_CAP_ARM_USER_IRQ: u32 = 144;
pub const KVM_CAP_S390_CMMA_MIGRATION: u32 = 145;
pub const KVM_CAP_PPC_FWNMI: u32 = 146;
pub const KVM_CAP_PPC_SMT_POSSIBLE: u32 = 147;
pub const KVM_CAP_HYPERV_SYNIC2: u32 = 148;
pub const KVM_CAP_HYPERV_VP_INDEX: u32 = 149;
pub const KVM_CAP_S390_AIS_MIGRATION: u32 = 150;
pub const KVM_CAP_PPC_GET_CPU_CHAR: u32 = 151;
pub const KVM_CAP_S390_BPB: u32 = 152;
pub const KVM_CAP_GET_MSR_FEATURES: u32 = 153;
pub const KVM_CAP_HYPERV_EVENTFD: u32 = 154;
pub const KVM_CAP_HYPERV_TLBFLUSH: u32 = 155;
pub const KVM_CAP_S390_HPAGE_1M: u32 = 156;
pub const KVM_CAP_NESTED_STATE: u32 = 157;
pub const KVM_CAP_ARM_INJECT_SERROR_ESR: u32 = 158;
pub const KVM_CAP_MSR_PLATFORM_INFO: u32 = 159;
pub const KVM_CAP_PPC_NESTED_HV: u32 = 160;
pub const KVM_CAP_HYPERV_SEND_IPI: u32 = 161;
pub const KVM_CAP_COALESCED_PIO: u32 = 162;
pub const KVM_CAP_HYPERV_ENLIGHTENED_VMCS: u32 = 163;
pub const KVM_CAP_EXCEPTION_PAYLOAD: u32 = 164;
pub const KVM_CAP_ARM_VM_IPA_SIZE: u32 = 165;
pub const KVM_IRQ_ROUTING_IRQCHIP: u32 = 1;
pub const KVM_IRQ_ROUTING_MSI: u32 = 2;
pub const KVM_IRQ_ROUTING_S390_ADAPTER: u32 = 3;
pub const KVM_IRQ_ROUTING_HV_SINT: u32 = 4;
pub const KVM_IRQFD_FLAG_DEASSIGN: u32 = 1;
pub const KVM_IRQFD_FLAG_RESAMPLE: u32 = 2;
pub const KVM_CLOCK_TSC_STABLE: u32 = 2;
pub const KVM_MMU_FSL_BOOKE_NOHV: u32 = 0;
pub const KVM_MMU_FSL_BOOKE_HV: u32 = 1;
pub const KVM_REG_ARCH_MASK: i64 = -72057594037927936;
pub const KVM_REG_GENERIC: u32 = 0;
pub const KVM_REG_PPC: u64 = 1152921504606846976;
pub const KVM_REG_X86: u64 = 2305843009213693952;
pub const KVM_REG_IA64: u64 = 3458764513820540928;
pub const KVM_REG_ARM: u64 = 4611686018427387904;
pub const KVM_REG_S390: u64 = 5764607523034234880;
pub const KVM_REG_ARM64: u64 = 6917529027641081856;
pub const KVM_REG_MIPS: u64 = 8070450532247928832;
pub const KVM_REG_SIZE_SHIFT: u32 = 52;
pub const KVM_REG_SIZE_MASK: u64 = 67553994410557440;
pub const KVM_REG_SIZE_U8: u32 = 0;
pub const KVM_REG_SIZE_U16: u64 = 4503599627370496;
pub const KVM_REG_SIZE_U32: u64 = 9007199254740992;
pub const KVM_REG_SIZE_U64: u64 = 13510798882111488;
pub const KVM_REG_SIZE_U128: u64 = 18014398509481984;
pub const KVM_REG_SIZE_U256: u64 = 22517998136852480;
pub const KVM_REG_SIZE_U512: u64 = 27021597764222976;
pub const KVM_REG_SIZE_U1024: u64 = 31525197391593472;
pub const KVM_MSI_VALID_DEVID: u32 = 1;
pub const KVM_CREATE_DEVICE_TEST: u32 = 1;
pub const KVM_DEV_VFIO_GROUP: u32 = 1;
pub const KVM_DEV_VFIO_GROUP_ADD: u32 = 1;
pub const KVM_DEV_VFIO_GROUP_DEL: u32 = 2;
pub const KVM_DEV_VFIO_GROUP_SET_SPAPR_TCE: u32 = 3;
pub const KVM_S390_STORE_STATUS_NOADDR: i32 = -1;
pub const KVM_S390_STORE_STATUS_PREFIXED: i32 = -2;
pub const KVM_DEV_ASSIGN_ENABLE_IOMMU: u32 = 1;
pub const KVM_DEV_ASSIGN_PCI_2_3: u32 = 2;
pub const KVM_DEV_ASSIGN_MASK_INTX: u32 = 4;
pub const KVM_DEV_IRQ_HOST_INTX: u32 = 1;
pub const KVM_DEV_IRQ_HOST_MSI: u32 = 2;
pub const KVM_DEV_IRQ_HOST_MSIX: u32 = 4;
pub const KVM_DEV_IRQ_GUEST_INTX: u32 = 256;
pub const KVM_DEV_IRQ_GUEST_MSI: u32 = 512;
pub const KVM_DEV_IRQ_GUEST_MSIX: u32 = 1024;
pub const KVM_DEV_IRQ_HOST_MASK: u32 = 255;
pub const KVM_DEV_IRQ_GUEST_MASK: u32 = 65280;
pub const KVM_MAX_MSIX_PER_DEV: u32 = 256;
pub const KVM_X2APIC_API_USE_32BIT_IDS: u32 = 1;
pub const KVM_X2APIC_API_DISABLE_BROADCAST_QUIRK: u32 = 2;
pub const KVM_ARM_DEV_EL1_VTIMER: u32 = 1;
pub const KVM_ARM_DEV_EL1_PTIMER: u32 = 2;
pub const KVM_ARM_DEV_PMU: u32 = 4;
pub const KVM_HYPERV_CONN_ID_MASK: u32 = 16777215;
pub const KVM_HYPERV_EVENTFD_DEASSIGN: u32 = 1;
pub type __s8 = ::std::os::raw::c_schar;
pub type __u8 = ::std::os::raw::c_uchar;
pub type __s16 = ::std::os::raw::c_short;
pub type __u16 = ::std::os::raw::c_ushort;
pub type __s32 = ::std::os::raw::c_int;
pub type __u32 = ::std::os::raw::c_uint;
pub type __s64 = ::std::os::raw::c_longlong;
pub type __u64 = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __kernel_fd_set {
    pub fds_bits: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___kernel_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<__kernel_fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__kernel_fd_set>())).fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_fd_set),
            "::",
            stringify!(fds_bits)
        )
    );
}
pub type __kernel_sighandler_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type __kernel_key_t = ::std::os::raw::c_int;
pub type __kernel_mqd_t = ::std::os::raw::c_int;
pub type __kernel_mode_t = ::std::os::raw::c_ushort;
pub type __kernel_ipc_pid_t = ::std::os::raw::c_ushort;
pub type __kernel_uid_t = ::std::os::raw::c_ushort;
pub type __kernel_gid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_dev_t = ::std::os::raw::c_ushort;
pub type __kernel_long_t = ::std::os::raw::c_long;
pub type __kernel_ulong_t = ::std::os::raw::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_pid_t = ::std::os::raw::c_int;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::std::os::raw::c_int;
pub type __kernel_uid32_t = ::std::os::raw::c_uint;
pub type __kernel_gid32_t = ::std::os::raw::c_uint;
pub type __kernel_old_uid_t = __kernel_uid_t;
pub type __kernel_old_gid_t = __kernel_gid_t;
pub type __kernel_size_t = ::std::os::raw::c_uint;
pub type __kernel_ssize_t = ::std::os::raw::c_int;
pub type __kernel_ptrdiff_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct __kernel_fsid_t {
    pub val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___kernel_fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__kernel_fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__kernel_fsid_t>())).val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__kernel_fsid_t),
            "::",
            stringify!(val)
        )
    );
}
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::std::os::raw::c_longlong;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_time64_t = ::std::os::raw::c_longlong;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::std::os::raw::c_int;
pub type __kernel_clockid_t = ::std::os::raw::c_int;
pub type __kernel_caddr_t = *mut ::std::os::raw::c_char;
pub type __kernel_uid16_t = ::std::os::raw::c_ushort;
pub type __kernel_gid16_t = ::std::os::raw::c_ushort;
pub type __le16 = __u16;
pub type __be16 = __u16;
pub type __le32 = __u32;
pub type __be32 = __u32;
pub type __le64 = __u64;
pub type __be64 = __u64;
pub type __sum16 = __u16;
pub type __wsum = __u32;
pub type __poll_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct pt_regs {
    pub uregs: [::std::os::raw::c_long; 18usize],
}
#[test]
fn bindgen_test_layout_pt_regs() {
    assert_eq!(
        ::std::mem::size_of::<pt_regs>(),
        144usize,
        concat!("Size of: ", stringify!(pt_regs))
    );
    assert_eq!(
        ::std::mem::align_of::<pt_regs>(),
        8usize,
        concat!("Alignment of ", stringify!(pt_regs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pt_regs>())).uregs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pt_regs),
            "::",
            stringify!(uregs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_regs {
    pub usr_regs: pt_regs,
    pub svc_regs: [::std::os::raw::c_ulong; 3usize],
    pub abt_regs: [::std::os::raw::c_ulong; 3usize],
    pub und_regs: [::std::os::raw::c_ulong; 3usize],
    pub irq_regs: [::std::os::raw::c_ulong; 3usize],
    pub fiq_regs: [::std::os::raw::c_ulong; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_regs() {
    assert_eq!(
        ::std::mem::size_of::<kvm_regs>(),
        304usize,
        concat!("Size of: ", stringify!(kvm_regs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_regs>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_regs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_regs>())).usr_regs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(usr_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_regs>())).svc_regs as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(svc_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_regs>())).abt_regs as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(abt_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_regs>())).und_regs as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(und_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_regs>())).irq_regs as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(irq_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_regs>())).fiq_regs as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_regs),
            "::",
            stringify!(fiq_regs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_vcpu_init {
    pub target: __u32,
    pub features: [__u32; 7usize],
}
#[test]
fn bindgen_test_layout_kvm_vcpu_init() {
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_init>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_vcpu_init))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_init>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_init))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_vcpu_init>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_init),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_vcpu_init>())).features as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_init),
            "::",
            stringify!(features)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sregs {}
#[test]
fn bindgen_test_layout_kvm_sregs() {
    assert_eq!(
        ::std::mem::size_of::<kvm_sregs>(),
        0usize,
        concat!("Size of: ", stringify!(kvm_sregs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sregs>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_sregs))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_fpu {}
#[test]
fn bindgen_test_layout_kvm_fpu() {
    assert_eq!(
        ::std::mem::size_of::<kvm_fpu>(),
        0usize,
        concat!("Size of: ", stringify!(kvm_fpu))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_fpu>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_fpu))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_guest_debug_arch {}
#[test]
fn bindgen_test_layout_kvm_guest_debug_arch() {
    assert_eq!(
        ::std::mem::size_of::<kvm_guest_debug_arch>(),
        0usize,
        concat!("Size of: ", stringify!(kvm_guest_debug_arch))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_guest_debug_arch>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_guest_debug_arch))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_debug_exit_arch {}
#[test]
fn bindgen_test_layout_kvm_debug_exit_arch() {
    assert_eq!(
        ::std::mem::size_of::<kvm_debug_exit_arch>(),
        0usize,
        concat!("Size of: ", stringify!(kvm_debug_exit_arch))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_debug_exit_arch>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_debug_exit_arch))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sync_regs {
    pub device_irq_level: __u64,
}
#[test]
fn bindgen_test_layout_kvm_sync_regs() {
    assert_eq!(
        ::std::mem::size_of::<kvm_sync_regs>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_sync_regs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sync_regs>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sync_regs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sync_regs>())).device_irq_level as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sync_regs),
            "::",
            stringify!(device_irq_level)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_arch_memory_slot {}
#[test]
fn bindgen_test_layout_kvm_arch_memory_slot() {
    assert_eq!(
        ::std::mem::size_of::<kvm_arch_memory_slot>(),
        0usize,
        concat!("Size of: ", stringify!(kvm_arch_memory_slot))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_arch_memory_slot>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_arch_memory_slot))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_vcpu_events {
    pub exception: kvm_vcpu_events__bindgen_ty_1,
    pub reserved: [__u32; 12usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_vcpu_events__bindgen_ty_1 {
    pub serror_pending: __u8,
    pub serror_has_esr: __u8,
    pub pad: [__u8; 6usize],
    pub serror_esr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_vcpu_events__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_vcpu_events__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_events__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_vcpu_events__bindgen_ty_1>())).serror_pending as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_1),
            "::",
            stringify!(serror_pending)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_vcpu_events__bindgen_ty_1>())).serror_has_esr as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_1),
            "::",
            stringify!(serror_has_esr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_vcpu_events__bindgen_ty_1>())).pad as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_vcpu_events__bindgen_ty_1>())).serror_esr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events__bindgen_ty_1),
            "::",
            stringify!(serror_esr)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_vcpu_events() {
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_events>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_vcpu_events))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_events>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_events))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_vcpu_events>())).exception as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events),
            "::",
            stringify!(exception)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_vcpu_events>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vcpu_events),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_user_trace_setup {
    pub buf_size: __u32,
    pub buf_nr: __u32,
}
#[test]
fn bindgen_test_layout_kvm_user_trace_setup() {
    assert_eq!(
        ::std::mem::size_of::<kvm_user_trace_setup>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_user_trace_setup))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_user_trace_setup>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_user_trace_setup))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_user_trace_setup>())).buf_size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_user_trace_setup),
            "::",
            stringify!(buf_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_user_trace_setup>())).buf_nr as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_user_trace_setup),
            "::",
            stringify!(buf_nr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_breakpoint {
    pub enabled: __u32,
    pub padding: __u32,
    pub address: __u64,
}
#[test]
fn bindgen_test_layout_kvm_breakpoint() {
    assert_eq!(
        ::std::mem::size_of::<kvm_breakpoint>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_breakpoint))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_breakpoint>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_breakpoint))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_breakpoint>())).enabled as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_breakpoint),
            "::",
            stringify!(enabled)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_breakpoint>())).padding as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_breakpoint),
            "::",
            stringify!(padding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_breakpoint>())).address as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_breakpoint),
            "::",
            stringify!(address)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_debug_guest {
    pub enabled: __u32,
    pub pad: __u32,
    pub breakpoints: [kvm_breakpoint; 4usize],
    pub singlestep: __u32,
}
#[test]
fn bindgen_test_layout_kvm_debug_guest() {
    assert_eq!(
        ::std::mem::size_of::<kvm_debug_guest>(),
        80usize,
        concat!("Size of: ", stringify!(kvm_debug_guest))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_debug_guest>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_debug_guest))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_debug_guest>())).enabled as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debug_guest),
            "::",
            stringify!(enabled)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_debug_guest>())).pad as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debug_guest),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_debug_guest>())).breakpoints as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debug_guest),
            "::",
            stringify!(breakpoints)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_debug_guest>())).singlestep as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_debug_guest),
            "::",
            stringify!(singlestep)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_memory_region {
    pub slot: __u32,
    pub flags: __u32,
    pub guest_phys_addr: __u64,
    pub memory_size: __u64,
}
#[test]
fn bindgen_test_layout_kvm_memory_region() {
    assert_eq!(
        ::std::mem::size_of::<kvm_memory_region>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_memory_region))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_memory_region>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_memory_region))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_memory_region>())).slot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_memory_region),
            "::",
            stringify!(slot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_memory_region>())).flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_memory_region),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_memory_region>())).guest_phys_addr as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_memory_region),
            "::",
            stringify!(guest_phys_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_memory_region>())).memory_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_memory_region),
            "::",
            stringify!(memory_size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_userspace_memory_region {
    pub slot: __u32,
    pub flags: __u32,
    pub guest_phys_addr: __u64,
    pub memory_size: __u64,
    pub userspace_addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_userspace_memory_region() {
    assert_eq!(
        ::std::mem::size_of::<kvm_userspace_memory_region>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_userspace_memory_region))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_userspace_memory_region>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_userspace_memory_region))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_userspace_memory_region>())).slot as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region),
            "::",
            stringify!(slot)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_userspace_memory_region>())).flags as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_userspace_memory_region>())).guest_phys_addr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region),
            "::",
            stringify!(guest_phys_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_userspace_memory_region>())).memory_size as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region),
            "::",
            stringify!(memory_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_userspace_memory_region>())).userspace_addr as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_userspace_memory_region),
            "::",
            stringify!(userspace_addr)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irq_level {
    pub __bindgen_anon_1: kvm_irq_level__bindgen_ty_1,
    pub level: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irq_level__bindgen_ty_1 {
    pub irq: __u32,
    pub status: __s32,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_level__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_level__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_irq_level__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_level__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_level__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_level__bindgen_ty_1>())).irq as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_level__bindgen_ty_1),
            "::",
            stringify!(irq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_irq_level__bindgen_ty_1>())).status as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_level__bindgen_ty_1),
            "::",
            stringify!(status)
        )
    );
}
impl Default for kvm_irq_level__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_irq_level() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_level>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_irq_level))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_level>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_level))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_level>())).level as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_level),
            "::",
            stringify!(level)
        )
    );
}
impl Default for kvm_irq_level {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irqchip {
    pub chip_id: __u32,
    pub pad: __u32,
    pub chip: kvm_irqchip__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irqchip__bindgen_ty_1 {
    pub dummy: [::std::os::raw::c_char; 512usize],
    _bindgen_union_align: [u8; 512usize],
}
#[test]
fn bindgen_test_layout_kvm_irqchip__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irqchip__bindgen_ty_1>(),
        512usize,
        concat!("Size of: ", stringify!(kvm_irqchip__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irqchip__bindgen_ty_1>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_irqchip__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irqchip__bindgen_ty_1>())).dummy as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqchip__bindgen_ty_1),
            "::",
            stringify!(dummy)
        )
    );
}
impl Default for kvm_irqchip__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_irqchip() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irqchip>(),
        520usize,
        concat!("Size of: ", stringify!(kvm_irqchip))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irqchip>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irqchip))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irqchip>())).chip_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqchip),
            "::",
            stringify!(chip_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irqchip>())).pad as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqchip),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irqchip>())).chip as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqchip),
            "::",
            stringify!(chip)
        )
    );
}
impl Default for kvm_irqchip {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_pit_config {
    pub flags: __u32,
    pub pad: [__u32; 15usize],
}
#[test]
fn bindgen_test_layout_kvm_pit_config() {
    assert_eq!(
        ::std::mem::size_of::<kvm_pit_config>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_pit_config))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_pit_config>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_pit_config))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_pit_config>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_config),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_pit_config>())).pad as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_pit_config),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_skeys {
    pub start_gfn: __u64,
    pub count: __u64,
    pub skeydata_addr: __u64,
    pub flags: __u32,
    pub reserved: [__u32; 9usize],
}
#[test]
fn bindgen_test_layout_kvm_s390_skeys() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_skeys>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_s390_skeys))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_skeys>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_skeys))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_skeys>())).start_gfn as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_skeys),
            "::",
            stringify!(start_gfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_skeys>())).count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_skeys),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_skeys>())).skeydata_addr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_skeys),
            "::",
            stringify!(skeydata_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_skeys>())).flags as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_skeys),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_skeys>())).reserved as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_skeys),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " kvm_s390_cmma_log - Used for CMMA migration."]
#[doc = ""]
#[doc = " Used both for input and output."]
#[doc = ""]
#[doc = " @start_gfn: Guest page number to start from."]
#[doc = " @count: Size of the result buffer."]
#[doc = " @flags: Control operation mode via KVM_S390_CMMA_* flags"]
#[doc = " @remaining: Used with KVM_S390_GET_CMMA_BITS. Indicates how many dirty"]
#[doc = "             pages are still remaining."]
#[doc = " @mask: Used with KVM_S390_SET_CMMA_BITS. Bitmap of bits to actually set"]
#[doc = "        in the PGSTE."]
#[doc = " @values: Pointer to the values buffer."]
#[doc = ""]
#[doc = " Used in KVM_S390_{G,S}ET_CMMA_BITS ioctls."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_s390_cmma_log {
    pub start_gfn: __u64,
    pub count: __u32,
    pub flags: __u32,
    pub __bindgen_anon_1: kvm_s390_cmma_log__bindgen_ty_1,
    pub values: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_s390_cmma_log__bindgen_ty_1 {
    pub remaining: __u64,
    pub mask: __u64,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_kvm_s390_cmma_log__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_cmma_log__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_s390_cmma_log__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_cmma_log__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_cmma_log__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_s390_cmma_log__bindgen_ty_1>())).remaining as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_cmma_log__bindgen_ty_1),
            "::",
            stringify!(remaining)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_s390_cmma_log__bindgen_ty_1>())).mask as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_cmma_log__bindgen_ty_1),
            "::",
            stringify!(mask)
        )
    );
}
impl Default for kvm_s390_cmma_log__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_s390_cmma_log() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_cmma_log>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_s390_cmma_log))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_cmma_log>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_cmma_log))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_cmma_log>())).start_gfn as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_cmma_log),
            "::",
            stringify!(start_gfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_cmma_log>())).count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_cmma_log),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_cmma_log>())).flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_cmma_log),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_cmma_log>())).values as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_cmma_log),
            "::",
            stringify!(values)
        )
    );
}
impl Default for kvm_s390_cmma_log {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_hyperv_exit {
    pub type_: __u32,
    pub u: kvm_hyperv_exit__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_hyperv_exit__bindgen_ty_1 {
    pub synic: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1,
    pub hcall: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2,
    _bindgen_union_align: [u64; 4usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1 {
    pub msr: __u32,
    pub control: __u64,
    pub evt_page: __u64,
    pub msg_page: __u64,
}
#[test]
fn bindgen_test_layout_kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1>())).msr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(msr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1>())).control
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(control)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1>())).evt_page
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(evt_page)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1>())).msg_page
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(msg_page)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2 {
    pub input: __u64,
    pub result: __u64,
    pub params: [__u64; 2usize],
}
#[test]
fn bindgen_test_layout_kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2>())).input
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(input)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2>())).result
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(result)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2>())).params
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(params)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_hyperv_exit__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_hyperv_exit__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_hyperv_exit__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_hyperv_exit__bindgen_ty_1>())).synic as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1),
            "::",
            stringify!(synic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_hyperv_exit__bindgen_ty_1>())).hcall as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1),
            "::",
            stringify!(hcall)
        )
    );
}
impl Default for kvm_hyperv_exit__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_hyperv_exit() {
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_exit>(),
        40usize,
        concat!("Size of: ", stringify!(kvm_hyperv_exit))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_exit>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_hyperv_exit))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_hyperv_exit>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_hyperv_exit>())).u as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_exit),
            "::",
            stringify!(u)
        )
    );
}
impl Default for kvm_hyperv_exit {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_run {
    pub request_interrupt_window: __u8,
    pub immediate_exit: __u8,
    pub padding1: [__u8; 6usize],
    pub exit_reason: __u32,
    pub ready_for_interrupt_injection: __u8,
    pub if_flag: __u8,
    pub flags: __u16,
    pub cr8: __u64,
    pub apic_base: __u64,
    pub __bindgen_anon_1: kvm_run__bindgen_ty_1,
    pub kvm_valid_regs: __u64,
    pub kvm_dirty_regs: __u64,
    pub s: kvm_run__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_1 {
    pub hw: kvm_run__bindgen_ty_1__bindgen_ty_1,
    pub fail_entry: kvm_run__bindgen_ty_1__bindgen_ty_2,
    pub ex: kvm_run__bindgen_ty_1__bindgen_ty_3,
    pub io: kvm_run__bindgen_ty_1__bindgen_ty_4,
    pub debug: kvm_run__bindgen_ty_1__bindgen_ty_5,
    pub mmio: kvm_run__bindgen_ty_1__bindgen_ty_6,
    pub hypercall: kvm_run__bindgen_ty_1__bindgen_ty_7,
    pub tpr_access: kvm_run__bindgen_ty_1__bindgen_ty_8,
    pub s390_sieic: kvm_run__bindgen_ty_1__bindgen_ty_9,
    pub s390_reset_flags: __u64,
    pub s390_ucontrol: kvm_run__bindgen_ty_1__bindgen_ty_10,
    pub dcr: kvm_run__bindgen_ty_1__bindgen_ty_11,
    pub internal: kvm_run__bindgen_ty_1__bindgen_ty_12,
    pub osi: kvm_run__bindgen_ty_1__bindgen_ty_13,
    pub papr_hcall: kvm_run__bindgen_ty_1__bindgen_ty_14,
    pub s390_tsch: kvm_run__bindgen_ty_1__bindgen_ty_15,
    pub epr: kvm_run__bindgen_ty_1__bindgen_ty_16,
    pub system_event: kvm_run__bindgen_ty_1__bindgen_ty_17,
    pub s390_stsi: kvm_run__bindgen_ty_1__bindgen_ty_18,
    pub eoi: kvm_run__bindgen_ty_1__bindgen_ty_19,
    pub hyperv: kvm_hyperv_exit,
    pub padding: [::std::os::raw::c_char; 256usize],
    _bindgen_union_align: [u64; 32usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_1 {
    pub hardware_exit_reason: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_1>())).hardware_exit_reason
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(hardware_exit_reason)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_2 {
    pub hardware_entry_failure_reason: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_2>()))
                .hardware_entry_failure_reason as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(hardware_entry_failure_reason)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_3 {
    pub exception: __u32,
    pub error_code: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_3>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_3>())).exception as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(exception)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_3>())).error_code as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(error_code)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_4 {
    pub direction: __u8,
    pub size: __u8,
    pub port: __u16,
    pub count: __u32,
    pub data_offset: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_4>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_4>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_4>())).direction as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(direction)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_4>())).size as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_4>())).port as *const _
                as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_4>())).count as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_4>())).data_offset as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(data_offset)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_5 {
    pub arch: kvm_debug_exit_arch,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_5() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_5>(),
        0usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_5))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_5>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_5>())).arch as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_5),
            "::",
            stringify!(arch)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_6 {
    pub phys_addr: __u64,
    pub data: [__u8; 8usize],
    pub len: __u32,
    pub is_write: __u8,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_6() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_6>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_6>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_6>())).phys_addr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(phys_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_6>())).data as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_6>())).len as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_6>())).is_write as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(is_write)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_7 {
    pub nr: __u64,
    pub args: [__u64; 6usize],
    pub ret: __u64,
    pub longmode: __u32,
    pub pad: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_7() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_7>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_7>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_7>())).nr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(nr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_7>())).args as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_7>())).ret as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(ret)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_7>())).longmode as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(longmode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_7>())).pad as *const _ as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_8 {
    pub rip: __u64,
    pub is_write: __u32,
    pub pad: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_8() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_8>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_8>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_8>())).rip as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_8>())).is_write as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8),
            "::",
            stringify!(is_write)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_8>())).pad as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_9 {
    pub icptcode: __u8,
    pub ipa: __u16,
    pub ipb: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_9() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_9>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_9))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_9>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_9>())).icptcode as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_9),
            "::",
            stringify!(icptcode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_9>())).ipa as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_9),
            "::",
            stringify!(ipa)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_9>())).ipb as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_9),
            "::",
            stringify!(ipb)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_10 {
    pub trans_exc_code: __u64,
    pub pgm_code: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_10() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_10>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_10)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_10>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_10>())).trans_exc_code
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_10),
            "::",
            stringify!(trans_exc_code)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_10>())).pgm_code as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_10),
            "::",
            stringify!(pgm_code)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_11 {
    pub dcrn: __u32,
    pub data: __u32,
    pub is_write: __u8,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_11() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_11>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_11)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_11>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_11>())).dcrn as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_11),
            "::",
            stringify!(dcrn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_11>())).data as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_11),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_11>())).is_write as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_11),
            "::",
            stringify!(is_write)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_12 {
    pub suberror: __u32,
    pub ndata: __u32,
    pub data: [__u64; 16usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_12() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_12>(),
        136usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_12)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_12>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_12>())).suberror as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_12),
            "::",
            stringify!(suberror)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_12>())).ndata as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_12),
            "::",
            stringify!(ndata)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_12>())).data as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_12),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_13 {
    pub gprs: [__u64; 32usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_13() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_13>(),
        256usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_13)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_13>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_13>())).gprs as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_13),
            "::",
            stringify!(gprs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_14 {
    pub nr: __u64,
    pub ret: __u64,
    pub args: [__u64; 9usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_14() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_14>(),
        88usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_14>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_14>())).nr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14),
            "::",
            stringify!(nr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_14>())).ret as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14),
            "::",
            stringify!(ret)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_14>())).args as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14),
            "::",
            stringify!(args)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_15 {
    pub subchannel_id: __u16,
    pub subchannel_nr: __u16,
    pub io_int_parm: __u32,
    pub io_int_word: __u32,
    pub ipb: __u32,
    pub dequeued: __u8,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_15() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_15>(),
        20usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_15)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_15>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_15>())).subchannel_id
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_15),
            "::",
            stringify!(subchannel_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_15>())).subchannel_nr
                as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_15),
            "::",
            stringify!(subchannel_nr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_15>())).io_int_parm as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_15),
            "::",
            stringify!(io_int_parm)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_15>())).io_int_word as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_15),
            "::",
            stringify!(io_int_word)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_15>())).ipb as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_15),
            "::",
            stringify!(ipb)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_15>())).dequeued as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_15),
            "::",
            stringify!(dequeued)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_16 {
    pub epr: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_16() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_16>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_16)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_16>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_16>())).epr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_16),
            "::",
            stringify!(epr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_17 {
    pub type_: __u32,
    pub flags: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_17() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_17>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_17>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_17>())).type_ as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_17>())).flags as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_18 {
    pub addr: __u64,
    pub ar: __u8,
    pub reserved: __u8,
    pub fc: __u8,
    pub sel1: __u8,
    pub sel2: __u16,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_18() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_18>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_18)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_18>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_18)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_18>())).addr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_18),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_18>())).ar as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_18),
            "::",
            stringify!(ar)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_18>())).reserved as *const _
                as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_18),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_18>())).fc as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_18),
            "::",
            stringify!(fc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_18>())).sel1 as *const _
                as usize
        },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_18),
            "::",
            stringify!(sel1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_18>())).sel2 as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_18),
            "::",
            stringify!(sel2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_19 {
    pub vector: __u8,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_19() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_19>(),
        1usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_19)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_19>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_19)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1__bindgen_ty_19>())).vector as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_19),
            "::",
            stringify!(vector)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1>(),
        256usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_run__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).hw as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(hw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).fail_entry as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(fail_entry)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).ex as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(ex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).io as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(io)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).debug as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(debug)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).mmio as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(mmio)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).hypercall as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(hypercall)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).tpr_access as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(tpr_access)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).s390_sieic as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(s390_sieic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).s390_reset_flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(s390_reset_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).s390_ucontrol as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(s390_ucontrol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).dcr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(dcr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).internal as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(internal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).osi as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(osi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).papr_hcall as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(papr_hcall)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).s390_tsch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(s390_tsch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).epr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(epr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).system_event as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(system_event)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).s390_stsi as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(s390_stsi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).eoi as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(eoi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).hyperv as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(hyperv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_1>())).padding as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_1),
            "::",
            stringify!(padding)
        )
    );
}
impl Default for kvm_run__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_2 {
    pub regs: kvm_sync_regs,
    pub padding: [::std::os::raw::c_char; 2048usize],
    _bindgen_union_align: [u64; 256usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_2>(),
        2048usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_run__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_2>())).regs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_2),
            "::",
            stringify!(regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run__bindgen_ty_2>())).padding as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run__bindgen_ty_2),
            "::",
            stringify!(padding)
        )
    );
}
impl Default for kvm_run__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_run() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run>(),
        2352usize,
        concat!("Size of: ", stringify!(kvm_run))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_run))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run>())).request_interrupt_window as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(request_interrupt_window)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run>())).immediate_exit as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(immediate_exit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run>())).padding1 as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(padding1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run>())).exit_reason as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(exit_reason)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_run>())).ready_for_interrupt_injection as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(ready_for_interrupt_injection)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run>())).if_flag as *const _ as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(if_flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run>())).flags as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run>())).cr8 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(cr8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run>())).apic_base as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(apic_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run>())).kvm_valid_regs as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(kvm_valid_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run>())).kvm_dirty_regs as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(kvm_dirty_regs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_run>())).s as *const _ as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_run),
            "::",
            stringify!(s)
        )
    );
}
impl Default for kvm_run {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_coalesced_mmio_zone {
    pub addr: __u64,
    pub size: __u32,
    pub __bindgen_anon_1: kvm_coalesced_mmio_zone__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_coalesced_mmio_zone__bindgen_ty_1 {
    pub pad: __u32,
    pub pio: __u32,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_kvm_coalesced_mmio_zone__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_coalesced_mmio_zone__bindgen_ty_1>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(kvm_coalesced_mmio_zone__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_coalesced_mmio_zone__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_coalesced_mmio_zone__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_coalesced_mmio_zone__bindgen_ty_1>())).pad as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_zone__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_coalesced_mmio_zone__bindgen_ty_1>())).pio as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_zone__bindgen_ty_1),
            "::",
            stringify!(pio)
        )
    );
}
impl Default for kvm_coalesced_mmio_zone__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_coalesced_mmio_zone() {
    assert_eq!(
        ::std::mem::size_of::<kvm_coalesced_mmio_zone>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_coalesced_mmio_zone))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_coalesced_mmio_zone>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_coalesced_mmio_zone))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_coalesced_mmio_zone>())).addr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_zone),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_coalesced_mmio_zone>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_zone),
            "::",
            stringify!(size)
        )
    );
}
impl Default for kvm_coalesced_mmio_zone {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_coalesced_mmio {
    pub phys_addr: __u64,
    pub len: __u32,
    pub __bindgen_anon_1: kvm_coalesced_mmio__bindgen_ty_1,
    pub data: [__u8; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_coalesced_mmio__bindgen_ty_1 {
    pub pad: __u32,
    pub pio: __u32,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_kvm_coalesced_mmio__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_coalesced_mmio__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_coalesced_mmio__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_coalesced_mmio__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_coalesced_mmio__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_coalesced_mmio__bindgen_ty_1>())).pad as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_coalesced_mmio__bindgen_ty_1>())).pio as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio__bindgen_ty_1),
            "::",
            stringify!(pio)
        )
    );
}
impl Default for kvm_coalesced_mmio__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_coalesced_mmio() {
    assert_eq!(
        ::std::mem::size_of::<kvm_coalesced_mmio>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_coalesced_mmio))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_coalesced_mmio>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_coalesced_mmio))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_coalesced_mmio>())).phys_addr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio),
            "::",
            stringify!(phys_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_coalesced_mmio>())).len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_coalesced_mmio>())).data as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio),
            "::",
            stringify!(data)
        )
    );
}
impl Default for kvm_coalesced_mmio {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
pub struct kvm_coalesced_mmio_ring {
    pub first: __u32,
    pub last: __u32,
    pub coalesced_mmio: __IncompleteArrayField<kvm_coalesced_mmio>,
}
#[test]
fn bindgen_test_layout_kvm_coalesced_mmio_ring() {
    assert_eq!(
        ::std::mem::size_of::<kvm_coalesced_mmio_ring>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_coalesced_mmio_ring))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_coalesced_mmio_ring>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_coalesced_mmio_ring))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_coalesced_mmio_ring>())).first as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_ring),
            "::",
            stringify!(first)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_coalesced_mmio_ring>())).last as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_ring),
            "::",
            stringify!(last)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_coalesced_mmio_ring>())).coalesced_mmio as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_coalesced_mmio_ring),
            "::",
            stringify!(coalesced_mmio)
        )
    );
}
impl Default for kvm_coalesced_mmio_ring {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_translation {
    pub linear_address: __u64,
    pub physical_address: __u64,
    pub valid: __u8,
    pub writeable: __u8,
    pub usermode: __u8,
    pub pad: [__u8; 5usize],
}
#[test]
fn bindgen_test_layout_kvm_translation() {
    assert_eq!(
        ::std::mem::size_of::<kvm_translation>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_translation))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_translation>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_translation))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_translation>())).linear_address as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_translation),
            "::",
            stringify!(linear_address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_translation>())).physical_address as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_translation),
            "::",
            stringify!(physical_address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_translation>())).valid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_translation),
            "::",
            stringify!(valid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_translation>())).writeable as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_translation),
            "::",
            stringify!(writeable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_translation>())).usermode as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_translation),
            "::",
            stringify!(usermode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_translation>())).pad as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_translation),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_mem_op {
    pub gaddr: __u64,
    pub flags: __u64,
    pub size: __u32,
    pub op: __u32,
    pub buf: __u64,
    pub ar: __u8,
    pub reserved: [__u8; 31usize],
}
#[test]
fn bindgen_test_layout_kvm_s390_mem_op() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_mem_op>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_s390_mem_op))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_mem_op>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_mem_op))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_mem_op>())).gaddr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_mem_op),
            "::",
            stringify!(gaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_mem_op>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_mem_op),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_mem_op>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_mem_op),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_mem_op>())).op as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_mem_op),
            "::",
            stringify!(op)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_mem_op>())).buf as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_mem_op),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_mem_op>())).ar as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_mem_op),
            "::",
            stringify!(ar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_mem_op>())).reserved as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_mem_op),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_interrupt {
    pub irq: __u32,
}
#[test]
fn bindgen_test_layout_kvm_interrupt() {
    assert_eq!(
        ::std::mem::size_of::<kvm_interrupt>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_interrupt))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_interrupt>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_interrupt))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_interrupt>())).irq as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_interrupt),
            "::",
            stringify!(irq)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_dirty_log {
    pub slot: __u32,
    pub padding1: __u32,
    pub __bindgen_anon_1: kvm_dirty_log__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_dirty_log__bindgen_ty_1 {
    pub dirty_bitmap: *mut ::std::os::raw::c_void,
    pub padding2: __u64,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_kvm_dirty_log__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_dirty_log__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_dirty_log__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_dirty_log__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_dirty_log__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_dirty_log__bindgen_ty_1>())).dirty_bitmap as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_log__bindgen_ty_1),
            "::",
            stringify!(dirty_bitmap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_dirty_log__bindgen_ty_1>())).padding2 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_log__bindgen_ty_1),
            "::",
            stringify!(padding2)
        )
    );
}
impl Default for kvm_dirty_log__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_dirty_log() {
    assert_eq!(
        ::std::mem::size_of::<kvm_dirty_log>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_dirty_log))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_dirty_log>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_dirty_log))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_dirty_log>())).slot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_log),
            "::",
            stringify!(slot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_dirty_log>())).padding1 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_log),
            "::",
            stringify!(padding1)
        )
    );
}
impl Default for kvm_dirty_log {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_signal_mask {
    pub len: __u32,
    pub sigset: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_kvm_signal_mask() {
    assert_eq!(
        ::std::mem::size_of::<kvm_signal_mask>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_signal_mask))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_signal_mask>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_signal_mask))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_signal_mask>())).len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_signal_mask),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_signal_mask>())).sigset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_signal_mask),
            "::",
            stringify!(sigset)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_tpr_access_ctl {
    pub enabled: __u32,
    pub flags: __u32,
    pub reserved: [__u32; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_tpr_access_ctl() {
    assert_eq!(
        ::std::mem::size_of::<kvm_tpr_access_ctl>(),
        40usize,
        concat!("Size of: ", stringify!(kvm_tpr_access_ctl))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_tpr_access_ctl>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_tpr_access_ctl))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_tpr_access_ctl>())).enabled as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_tpr_access_ctl),
            "::",
            stringify!(enabled)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_tpr_access_ctl>())).flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_tpr_access_ctl),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_tpr_access_ctl>())).reserved as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_tpr_access_ctl),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_vapic_addr {
    pub vapic_addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_vapic_addr() {
    assert_eq!(
        ::std::mem::size_of::<kvm_vapic_addr>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_vapic_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vapic_addr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_vapic_addr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_vapic_addr>())).vapic_addr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vapic_addr),
            "::",
            stringify!(vapic_addr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_mp_state {
    pub mp_state: __u32,
}
#[test]
fn bindgen_test_layout_kvm_mp_state() {
    assert_eq!(
        ::std::mem::size_of::<kvm_mp_state>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_mp_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_mp_state>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_mp_state))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_mp_state>())).mp_state as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_mp_state),
            "::",
            stringify!(mp_state)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_psw {
    pub mask: __u64,
    pub addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_s390_psw() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_psw>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_s390_psw))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_psw>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_psw))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_psw>())).mask as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_psw),
            "::",
            stringify!(mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_psw>())).addr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_psw),
            "::",
            stringify!(addr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_interrupt {
    pub type_: __u32,
    pub parm: __u32,
    pub parm64: __u64,
}
#[test]
fn bindgen_test_layout_kvm_s390_interrupt() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_interrupt>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_s390_interrupt))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_interrupt>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_interrupt))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_interrupt>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_interrupt),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_interrupt>())).parm as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_interrupt),
            "::",
            stringify!(parm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_interrupt>())).parm64 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_interrupt),
            "::",
            stringify!(parm64)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_io_info {
    pub subchannel_id: __u16,
    pub subchannel_nr: __u16,
    pub io_int_parm: __u32,
    pub io_int_word: __u32,
}
#[test]
fn bindgen_test_layout_kvm_s390_io_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_io_info>(),
        12usize,
        concat!("Size of: ", stringify!(kvm_s390_io_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_io_info>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_s390_io_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_io_info>())).subchannel_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_io_info),
            "::",
            stringify!(subchannel_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_io_info>())).subchannel_nr as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_io_info),
            "::",
            stringify!(subchannel_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_io_info>())).io_int_parm as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_io_info),
            "::",
            stringify!(io_int_parm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_io_info>())).io_int_word as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_io_info),
            "::",
            stringify!(io_int_word)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_ext_info {
    pub ext_params: __u32,
    pub pad: __u32,
    pub ext_params2: __u64,
}
#[test]
fn bindgen_test_layout_kvm_s390_ext_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_ext_info>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_s390_ext_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_ext_info>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_ext_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_ext_info>())).ext_params as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_ext_info),
            "::",
            stringify!(ext_params)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_ext_info>())).pad as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_ext_info),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_ext_info>())).ext_params2 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_ext_info),
            "::",
            stringify!(ext_params2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_pgm_info {
    pub trans_exc_code: __u64,
    pub mon_code: __u64,
    pub per_address: __u64,
    pub data_exc_code: __u32,
    pub code: __u16,
    pub mon_class_nr: __u16,
    pub per_code: __u8,
    pub per_atmid: __u8,
    pub exc_access_id: __u8,
    pub per_access_id: __u8,
    pub op_access_id: __u8,
    pub flags: __u8,
    pub pad: [__u8; 2usize],
}
#[test]
fn bindgen_test_layout_kvm_s390_pgm_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_pgm_info>(),
        40usize,
        concat!("Size of: ", stringify!(kvm_s390_pgm_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_pgm_info>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_pgm_info))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_s390_pgm_info>())).trans_exc_code as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_pgm_info),
            "::",
            stringify!(trans_exc_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_pgm_info>())).mon_code as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_pgm_info),
            "::",
            stringify!(mon_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_pgm_info>())).per_address as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_pgm_info),
            "::",
            stringify!(per_address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_pgm_info>())).data_exc_code as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_pgm_info),
            "::",
            stringify!(data_exc_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_pgm_info>())).code as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_pgm_info),
            "::",
            stringify!(code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_pgm_info>())).mon_class_nr as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_pgm_info),
            "::",
            stringify!(mon_class_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_pgm_info>())).per_code as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_pgm_info),
            "::",
            stringify!(per_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_pgm_info>())).per_atmid as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_pgm_info),
            "::",
            stringify!(per_atmid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_pgm_info>())).exc_access_id as *const _ as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_pgm_info),
            "::",
            stringify!(exc_access_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_pgm_info>())).per_access_id as *const _ as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_pgm_info),
            "::",
            stringify!(per_access_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_pgm_info>())).op_access_id as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_pgm_info),
            "::",
            stringify!(op_access_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_pgm_info>())).flags as *const _ as usize },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_pgm_info),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_pgm_info>())).pad as *const _ as usize },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_pgm_info),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_prefix_info {
    pub address: __u32,
}
#[test]
fn bindgen_test_layout_kvm_s390_prefix_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_prefix_info>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_s390_prefix_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_prefix_info>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_s390_prefix_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_prefix_info>())).address as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_prefix_info),
            "::",
            stringify!(address)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_extcall_info {
    pub code: __u16,
}
#[test]
fn bindgen_test_layout_kvm_s390_extcall_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_extcall_info>(),
        2usize,
        concat!("Size of: ", stringify!(kvm_s390_extcall_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_extcall_info>(),
        2usize,
        concat!("Alignment of ", stringify!(kvm_s390_extcall_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_extcall_info>())).code as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_extcall_info),
            "::",
            stringify!(code)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_emerg_info {
    pub code: __u16,
}
#[test]
fn bindgen_test_layout_kvm_s390_emerg_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_emerg_info>(),
        2usize,
        concat!("Size of: ", stringify!(kvm_s390_emerg_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_emerg_info>(),
        2usize,
        concat!("Alignment of ", stringify!(kvm_s390_emerg_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_emerg_info>())).code as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_emerg_info),
            "::",
            stringify!(code)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_stop_info {
    pub flags: __u32,
}
#[test]
fn bindgen_test_layout_kvm_s390_stop_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_stop_info>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_s390_stop_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_stop_info>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_s390_stop_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_stop_info>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_stop_info),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_mchk_info {
    pub cr14: __u64,
    pub mcic: __u64,
    pub failing_storage_address: __u64,
    pub ext_damage_code: __u32,
    pub pad: __u32,
    pub fixed_logout: [__u8; 16usize],
}
#[test]
fn bindgen_test_layout_kvm_s390_mchk_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_mchk_info>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_s390_mchk_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_mchk_info>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_mchk_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_mchk_info>())).cr14 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_mchk_info),
            "::",
            stringify!(cr14)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_mchk_info>())).mcic as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_mchk_info),
            "::",
            stringify!(mcic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_s390_mchk_info>())).failing_storage_address as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_mchk_info),
            "::",
            stringify!(failing_storage_address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_s390_mchk_info>())).ext_damage_code as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_mchk_info),
            "::",
            stringify!(ext_damage_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_mchk_info>())).pad as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_mchk_info),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_mchk_info>())).fixed_logout as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_mchk_info),
            "::",
            stringify!(fixed_logout)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_s390_irq {
    pub type_: __u64,
    pub u: kvm_s390_irq__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_s390_irq__bindgen_ty_1 {
    pub io: kvm_s390_io_info,
    pub ext: kvm_s390_ext_info,
    pub pgm: kvm_s390_pgm_info,
    pub emerg: kvm_s390_emerg_info,
    pub extcall: kvm_s390_extcall_info,
    pub prefix: kvm_s390_prefix_info,
    pub stop: kvm_s390_stop_info,
    pub mchk: kvm_s390_mchk_info,
    pub reserved: [::std::os::raw::c_char; 64usize],
    _bindgen_union_align: [u64; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_s390_irq__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_irq__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_s390_irq__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_irq__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_irq__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_irq__bindgen_ty_1>())).io as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq__bindgen_ty_1),
            "::",
            stringify!(io)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_irq__bindgen_ty_1>())).ext as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq__bindgen_ty_1),
            "::",
            stringify!(ext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_irq__bindgen_ty_1>())).pgm as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq__bindgen_ty_1),
            "::",
            stringify!(pgm)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_s390_irq__bindgen_ty_1>())).emerg as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq__bindgen_ty_1),
            "::",
            stringify!(emerg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_s390_irq__bindgen_ty_1>())).extcall as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq__bindgen_ty_1),
            "::",
            stringify!(extcall)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_s390_irq__bindgen_ty_1>())).prefix as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq__bindgen_ty_1),
            "::",
            stringify!(prefix)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_irq__bindgen_ty_1>())).stop as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq__bindgen_ty_1),
            "::",
            stringify!(stop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_irq__bindgen_ty_1>())).mchk as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq__bindgen_ty_1),
            "::",
            stringify!(mchk)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_s390_irq__bindgen_ty_1>())).reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq__bindgen_ty_1),
            "::",
            stringify!(reserved)
        )
    );
}
impl Default for kvm_s390_irq__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_s390_irq() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_irq>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_s390_irq))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_irq>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_irq))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_irq>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_irq>())).u as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq),
            "::",
            stringify!(u)
        )
    );
}
impl Default for kvm_s390_irq {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_irq_state {
    pub buf: __u64,
    pub flags: __u32,
    pub len: __u32,
    pub reserved: [__u32; 4usize],
}
#[test]
fn bindgen_test_layout_kvm_s390_irq_state() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_irq_state>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_s390_irq_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_irq_state>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_irq_state))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_irq_state>())).buf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq_state),
            "::",
            stringify!(buf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_irq_state>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq_state),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_irq_state>())).len as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq_state),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_irq_state>())).reserved as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_irq_state),
            "::",
            stringify!(reserved)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_guest_debug {
    pub control: __u32,
    pub pad: __u32,
    pub arch: kvm_guest_debug_arch,
}
#[test]
fn bindgen_test_layout_kvm_guest_debug() {
    assert_eq!(
        ::std::mem::size_of::<kvm_guest_debug>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_guest_debug))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_guest_debug>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_guest_debug))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_guest_debug>())).control as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_guest_debug),
            "::",
            stringify!(control)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_guest_debug>())).pad as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_guest_debug),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_guest_debug>())).arch as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_guest_debug),
            "::",
            stringify!(arch)
        )
    );
}
pub const kvm_ioeventfd_flag_nr_datamatch: _bindgen_ty_1 = 0;
pub const kvm_ioeventfd_flag_nr_pio: _bindgen_ty_1 = 1;
pub const kvm_ioeventfd_flag_nr_deassign: _bindgen_ty_1 = 2;
pub const kvm_ioeventfd_flag_nr_virtio_ccw_notify: _bindgen_ty_1 = 3;
pub const kvm_ioeventfd_flag_nr_fast_mmio: _bindgen_ty_1 = 4;
pub const kvm_ioeventfd_flag_nr_max: _bindgen_ty_1 = 5;
pub type _bindgen_ty_1 = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_ioeventfd {
    pub datamatch: __u64,
    pub addr: __u64,
    pub len: __u32,
    pub fd: __s32,
    pub flags: __u32,
    pub pad: [__u8; 36usize],
}
#[test]
fn bindgen_test_layout_kvm_ioeventfd() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ioeventfd>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_ioeventfd))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ioeventfd>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_ioeventfd))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ioeventfd>())).datamatch as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioeventfd),
            "::",
            stringify!(datamatch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ioeventfd>())).addr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioeventfd),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ioeventfd>())).len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioeventfd),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ioeventfd>())).fd as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioeventfd),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ioeventfd>())).flags as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioeventfd),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ioeventfd>())).pad as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ioeventfd),
            "::",
            stringify!(pad)
        )
    );
}
impl Default for kvm_ioeventfd {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_enable_cap {
    pub cap: __u32,
    pub flags: __u32,
    pub args: [__u64; 4usize],
    pub pad: [__u8; 64usize],
}
#[test]
fn bindgen_test_layout_kvm_enable_cap() {
    assert_eq!(
        ::std::mem::size_of::<kvm_enable_cap>(),
        104usize,
        concat!("Size of: ", stringify!(kvm_enable_cap))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_enable_cap>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_enable_cap))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_enable_cap>())).cap as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_enable_cap),
            "::",
            stringify!(cap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_enable_cap>())).flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_enable_cap),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_enable_cap>())).args as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_enable_cap),
            "::",
            stringify!(args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_enable_cap>())).pad as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_enable_cap),
            "::",
            stringify!(pad)
        )
    );
}
impl Default for kvm_enable_cap {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_ppc_pvinfo {
    pub flags: __u32,
    pub hcall: [__u32; 4usize],
    pub pad: [__u8; 108usize],
}
#[test]
fn bindgen_test_layout_kvm_ppc_pvinfo() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ppc_pvinfo>(),
        128usize,
        concat!("Size of: ", stringify!(kvm_ppc_pvinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ppc_pvinfo>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_ppc_pvinfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ppc_pvinfo>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_pvinfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ppc_pvinfo>())).hcall as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_pvinfo),
            "::",
            stringify!(hcall)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ppc_pvinfo>())).pad as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_pvinfo),
            "::",
            stringify!(pad)
        )
    );
}
impl Default for kvm_ppc_pvinfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_ppc_one_page_size {
    pub page_shift: __u32,
    pub pte_enc: __u32,
}
#[test]
fn bindgen_test_layout_kvm_ppc_one_page_size() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ppc_one_page_size>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_ppc_one_page_size))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ppc_one_page_size>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_ppc_one_page_size))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_ppc_one_page_size>())).page_shift as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_one_page_size),
            "::",
            stringify!(page_shift)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ppc_one_page_size>())).pte_enc as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_one_page_size),
            "::",
            stringify!(pte_enc)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_ppc_one_seg_page_size {
    pub page_shift: __u32,
    pub slb_enc: __u32,
    pub enc: [kvm_ppc_one_page_size; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_ppc_one_seg_page_size() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ppc_one_seg_page_size>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_ppc_one_seg_page_size))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ppc_one_seg_page_size>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_ppc_one_seg_page_size))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_ppc_one_seg_page_size>())).page_shift as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_one_seg_page_size),
            "::",
            stringify!(page_shift)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_ppc_one_seg_page_size>())).slb_enc as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_one_seg_page_size),
            "::",
            stringify!(slb_enc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ppc_one_seg_page_size>())).enc as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_one_seg_page_size),
            "::",
            stringify!(enc)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_ppc_smmu_info {
    pub flags: __u64,
    pub slb_size: __u32,
    pub data_keys: __u16,
    pub instr_keys: __u16,
    pub sps: [kvm_ppc_one_seg_page_size; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_ppc_smmu_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ppc_smmu_info>(),
        592usize,
        concat!("Size of: ", stringify!(kvm_ppc_smmu_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ppc_smmu_info>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_ppc_smmu_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ppc_smmu_info>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_smmu_info),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ppc_smmu_info>())).slb_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_smmu_info),
            "::",
            stringify!(slb_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ppc_smmu_info>())).data_keys as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_smmu_info),
            "::",
            stringify!(data_keys)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ppc_smmu_info>())).instr_keys as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_smmu_info),
            "::",
            stringify!(instr_keys)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ppc_smmu_info>())).sps as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_smmu_info),
            "::",
            stringify!(sps)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_ppc_resize_hpt {
    pub flags: __u64,
    pub shift: __u32,
    pub pad: __u32,
}
#[test]
fn bindgen_test_layout_kvm_ppc_resize_hpt() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ppc_resize_hpt>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_ppc_resize_hpt))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ppc_resize_hpt>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_ppc_resize_hpt))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ppc_resize_hpt>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_resize_hpt),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ppc_resize_hpt>())).shift as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_resize_hpt),
            "::",
            stringify!(shift)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_ppc_resize_hpt>())).pad as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_ppc_resize_hpt),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irq_routing_irqchip {
    pub irqchip: __u32,
    pub pin: __u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_irqchip() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_irqchip>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_irqchip))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_irqchip>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_irqchip))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing_irqchip>())).irqchip as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_irqchip),
            "::",
            stringify!(irqchip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing_irqchip>())).pin as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_irqchip),
            "::",
            stringify!(pin)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irq_routing_msi {
    pub address_lo: __u32,
    pub address_hi: __u32,
    pub data: __u32,
    pub __bindgen_anon_1: kvm_irq_routing_msi__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irq_routing_msi__bindgen_ty_1 {
    pub pad: __u32,
    pub devid: __u32,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_msi__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_msi__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_msi__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_msi__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_irq_routing_msi__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_irq_routing_msi__bindgen_ty_1>())).pad as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_msi__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_irq_routing_msi__bindgen_ty_1>())).devid as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_msi__bindgen_ty_1),
            "::",
            stringify!(devid)
        )
    );
}
impl Default for kvm_irq_routing_msi__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_msi() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_msi>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_msi))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_msi>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_msi))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing_msi>())).address_lo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_msi),
            "::",
            stringify!(address_lo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing_msi>())).address_hi as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_msi),
            "::",
            stringify!(address_hi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing_msi>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_msi),
            "::",
            stringify!(data)
        )
    );
}
impl Default for kvm_irq_routing_msi {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irq_routing_s390_adapter {
    pub ind_addr: __u64,
    pub summary_addr: __u64,
    pub ind_offset: __u64,
    pub summary_offset: __u32,
    pub adapter_id: __u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_s390_adapter() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_s390_adapter>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_s390_adapter))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_s390_adapter>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_s390_adapter))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_irq_routing_s390_adapter>())).ind_addr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_s390_adapter),
            "::",
            stringify!(ind_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_irq_routing_s390_adapter>())).summary_addr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_s390_adapter),
            "::",
            stringify!(summary_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_irq_routing_s390_adapter>())).ind_offset as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_s390_adapter),
            "::",
            stringify!(ind_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_irq_routing_s390_adapter>())).summary_offset as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_s390_adapter),
            "::",
            stringify!(summary_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_irq_routing_s390_adapter>())).adapter_id as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_s390_adapter),
            "::",
            stringify!(adapter_id)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irq_routing_hv_sint {
    pub vcpu: __u32,
    pub sint: __u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_hv_sint() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_hv_sint>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_hv_sint))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_hv_sint>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_hv_sint))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing_hv_sint>())).vcpu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_hv_sint),
            "::",
            stringify!(vcpu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing_hv_sint>())).sint as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_hv_sint),
            "::",
            stringify!(sint)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irq_routing_entry {
    pub gsi: __u32,
    pub type_: __u32,
    pub flags: __u32,
    pub pad: __u32,
    pub u: kvm_irq_routing_entry__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irq_routing_entry__bindgen_ty_1 {
    pub irqchip: kvm_irq_routing_irqchip,
    pub msi: kvm_irq_routing_msi,
    pub adapter: kvm_irq_routing_s390_adapter,
    pub hv_sint: kvm_irq_routing_hv_sint,
    pub pad: [__u32; 8usize],
    _bindgen_union_align: [u64; 4usize],
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_entry__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_entry__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_entry__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_entry__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_irq_routing_entry__bindgen_ty_1>())).irqchip as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1),
            "::",
            stringify!(irqchip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_irq_routing_entry__bindgen_ty_1>())).msi as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1),
            "::",
            stringify!(msi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_irq_routing_entry__bindgen_ty_1>())).adapter as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1),
            "::",
            stringify!(adapter)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_irq_routing_entry__bindgen_ty_1>())).hv_sint as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1),
            "::",
            stringify!(hv_sint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_irq_routing_entry__bindgen_ty_1>())).pad as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1),
            "::",
            stringify!(pad)
        )
    );
}
impl Default for kvm_irq_routing_entry__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_entry() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_entry>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_entry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing_entry>())).gsi as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry),
            "::",
            stringify!(gsi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing_entry>())).type_ as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing_entry>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing_entry>())).pad as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry),
            "::",
            stringify!(pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing_entry>())).u as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing_entry),
            "::",
            stringify!(u)
        )
    );
}
impl Default for kvm_irq_routing_entry {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
pub struct kvm_irq_routing {
    pub nr: __u32,
    pub flags: __u32,
    pub entries: __IncompleteArrayField<kvm_irq_routing_entry>,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_irq_routing))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing>())).nr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing),
            "::",
            stringify!(nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing>())).flags as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irq_routing>())).entries as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irq_routing),
            "::",
            stringify!(entries)
        )
    );
}
impl Default for kvm_irq_routing {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_irqfd {
    pub fd: __u32,
    pub gsi: __u32,
    pub flags: __u32,
    pub resamplefd: __u32,
    pub pad: [__u8; 16usize],
}
#[test]
fn bindgen_test_layout_kvm_irqfd() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irqfd>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_irqfd))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irqfd>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irqfd))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irqfd>())).fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqfd),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irqfd>())).gsi as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqfd),
            "::",
            stringify!(gsi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irqfd>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqfd),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irqfd>())).resamplefd as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqfd),
            "::",
            stringify!(resamplefd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_irqfd>())).pad as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_irqfd),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_clock_data {
    pub clock: __u64,
    pub flags: __u32,
    pub pad: [__u32; 9usize],
}
#[test]
fn bindgen_test_layout_kvm_clock_data() {
    assert_eq!(
        ::std::mem::size_of::<kvm_clock_data>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_clock_data))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_clock_data>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_clock_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_clock_data>())).clock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clock_data),
            "::",
            stringify!(clock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_clock_data>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clock_data),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_clock_data>())).pad as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_clock_data),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_config_tlb {
    pub params: __u64,
    pub array: __u64,
    pub mmu_type: __u32,
    pub array_len: __u32,
}
#[test]
fn bindgen_test_layout_kvm_config_tlb() {
    assert_eq!(
        ::std::mem::size_of::<kvm_config_tlb>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_config_tlb))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_config_tlb>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_config_tlb))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_config_tlb>())).params as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_config_tlb),
            "::",
            stringify!(params)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_config_tlb>())).array as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_config_tlb),
            "::",
            stringify!(array)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_config_tlb>())).mmu_type as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_config_tlb),
            "::",
            stringify!(mmu_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_config_tlb>())).array_len as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_config_tlb),
            "::",
            stringify!(array_len)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_dirty_tlb {
    pub bitmap: __u64,
    pub num_dirty: __u32,
}
#[test]
fn bindgen_test_layout_kvm_dirty_tlb() {
    assert_eq!(
        ::std::mem::size_of::<kvm_dirty_tlb>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_dirty_tlb))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_dirty_tlb>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_dirty_tlb))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_dirty_tlb>())).bitmap as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_tlb),
            "::",
            stringify!(bitmap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_dirty_tlb>())).num_dirty as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_dirty_tlb),
            "::",
            stringify!(num_dirty)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_reg_list {
    pub n: __u64,
    pub reg: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_kvm_reg_list() {
    assert_eq!(
        ::std::mem::size_of::<kvm_reg_list>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_reg_list))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_reg_list>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_reg_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_reg_list>())).n as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_reg_list),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_reg_list>())).reg as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_reg_list),
            "::",
            stringify!(reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_one_reg {
    pub id: __u64,
    pub addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_one_reg() {
    assert_eq!(
        ::std::mem::size_of::<kvm_one_reg>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_one_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_one_reg>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_one_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_one_reg>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_one_reg),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_one_reg>())).addr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_one_reg),
            "::",
            stringify!(addr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_msi {
    pub address_lo: __u32,
    pub address_hi: __u32,
    pub data: __u32,
    pub flags: __u32,
    pub devid: __u32,
    pub pad: [__u8; 12usize],
}
#[test]
fn bindgen_test_layout_kvm_msi() {
    assert_eq!(
        ::std::mem::size_of::<kvm_msi>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_msi))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_msi>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_msi))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_msi>())).address_lo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msi),
            "::",
            stringify!(address_lo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_msi>())).address_hi as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msi),
            "::",
            stringify!(address_hi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_msi>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msi),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_msi>())).flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msi),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_msi>())).devid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msi),
            "::",
            stringify!(devid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_msi>())).pad as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_msi),
            "::",
            stringify!(pad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_arm_device_addr {
    pub id: __u64,
    pub addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_arm_device_addr() {
    assert_eq!(
        ::std::mem::size_of::<kvm_arm_device_addr>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_arm_device_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_arm_device_addr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_arm_device_addr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_arm_device_addr>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_arm_device_addr),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_arm_device_addr>())).addr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_arm_device_addr),
            "::",
            stringify!(addr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_create_device {
    pub type_: __u32,
    pub fd: __u32,
    pub flags: __u32,
}
#[test]
fn bindgen_test_layout_kvm_create_device() {
    assert_eq!(
        ::std::mem::size_of::<kvm_create_device>(),
        12usize,
        concat!("Size of: ", stringify!(kvm_create_device))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_create_device>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_create_device))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_create_device>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_create_device),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_create_device>())).fd as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_create_device),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_create_device>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_create_device),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_device_attr {
    pub flags: __u32,
    pub group: __u32,
    pub attr: __u64,
    pub addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_device_attr() {
    assert_eq!(
        ::std::mem::size_of::<kvm_device_attr>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_device_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_device_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_device_attr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_device_attr>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_device_attr),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_device_attr>())).group as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_device_attr),
            "::",
            stringify!(group)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_device_attr>())).attr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_device_attr),
            "::",
            stringify!(attr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_device_attr>())).addr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_device_attr),
            "::",
            stringify!(addr)
        )
    );
}
pub const kvm_device_type_KVM_DEV_TYPE_FSL_MPIC_20: kvm_device_type = 1;
pub const kvm_device_type_KVM_DEV_TYPE_FSL_MPIC_42: kvm_device_type = 2;
pub const kvm_device_type_KVM_DEV_TYPE_XICS: kvm_device_type = 3;
pub const kvm_device_type_KVM_DEV_TYPE_VFIO: kvm_device_type = 4;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_VGIC_V2: kvm_device_type = 5;
pub const kvm_device_type_KVM_DEV_TYPE_FLIC: kvm_device_type = 6;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_VGIC_V3: kvm_device_type = 7;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_VGIC_ITS: kvm_device_type = 8;
pub const kvm_device_type_KVM_DEV_TYPE_MAX: kvm_device_type = 9;
pub type kvm_device_type = u32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_vfio_spapr_tce {
    pub groupfd: __s32,
    pub tablefd: __s32,
}
#[test]
fn bindgen_test_layout_kvm_vfio_spapr_tce() {
    assert_eq!(
        ::std::mem::size_of::<kvm_vfio_spapr_tce>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_vfio_spapr_tce))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vfio_spapr_tce>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_vfio_spapr_tce))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_vfio_spapr_tce>())).groupfd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vfio_spapr_tce),
            "::",
            stringify!(groupfd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_vfio_spapr_tce>())).tablefd as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_vfio_spapr_tce),
            "::",
            stringify!(tablefd)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_s390_ucas_mapping {
    pub user_addr: __u64,
    pub vcpu_addr: __u64,
    pub length: __u64,
}
#[test]
fn bindgen_test_layout_kvm_s390_ucas_mapping() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_ucas_mapping>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_s390_ucas_mapping))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_ucas_mapping>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_ucas_mapping))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_ucas_mapping>())).user_addr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_ucas_mapping),
            "::",
            stringify!(user_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_ucas_mapping>())).vcpu_addr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_ucas_mapping),
            "::",
            stringify!(vcpu_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_s390_ucas_mapping>())).length as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_s390_ucas_mapping),
            "::",
            stringify!(length)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_enc_region {
    pub addr: __u64,
    pub size: __u64,
}
#[test]
fn bindgen_test_layout_kvm_enc_region() {
    assert_eq!(
        ::std::mem::size_of::<kvm_enc_region>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_enc_region))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_enc_region>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_enc_region))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_enc_region>())).addr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_enc_region),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_enc_region>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_enc_region),
            "::",
            stringify!(size)
        )
    );
}
pub const sev_cmd_id_KVM_SEV_INIT: sev_cmd_id = 0;
pub const sev_cmd_id_KVM_SEV_ES_INIT: sev_cmd_id = 1;
pub const sev_cmd_id_KVM_SEV_LAUNCH_START: sev_cmd_id = 2;
pub const sev_cmd_id_KVM_SEV_LAUNCH_UPDATE_DATA: sev_cmd_id = 3;
pub const sev_cmd_id_KVM_SEV_LAUNCH_UPDATE_VMSA: sev_cmd_id = 4;
pub const sev_cmd_id_KVM_SEV_LAUNCH_SECRET: sev_cmd_id = 5;
pub const sev_cmd_id_KVM_SEV_LAUNCH_MEASURE: sev_cmd_id = 6;
pub const sev_cmd_id_KVM_SEV_LAUNCH_FINISH: sev_cmd_id = 7;
pub const sev_cmd_id_KVM_SEV_SEND_START: sev_cmd_id = 8;
pub const sev_cmd_id_KVM_SEV_SEND_UPDATE_DATA: sev_cmd_id = 9;
pub const sev_cmd_id_KVM_SEV_SEND_UPDATE_VMSA: sev_cmd_id = 10;
pub const sev_cmd_id_KVM_SEV_SEND_FINISH: sev_cmd_id = 11;
pub const sev_cmd_id_KVM_SEV_RECEIVE_START: sev_cmd_id = 12;
pub const sev_cmd_id_KVM_SEV_RECEIVE_UPDATE_DATA: sev_cmd_id = 13;
pub const sev_cmd_id_KVM_SEV_RECEIVE_UPDATE_VMSA: sev_cmd_id = 14;
pub const sev_cmd_id_KVM_SEV_RECEIVE_FINISH: sev_cmd_id = 15;
pub const sev_cmd_id_KVM_SEV_GUEST_STATUS: sev_cmd_id = 16;
pub const sev_cmd_id_KVM_SEV_DBG_DECRYPT: sev_cmd_id = 17;
pub const sev_cmd_id_KVM_SEV_DBG_ENCRYPT: sev_cmd_id = 18;
pub const sev_cmd_id_KVM_SEV_CERT_EXPORT: sev_cmd_id = 19;
pub const sev_cmd_id_KVM_SEV_NR_MAX: sev_cmd_id = 20;
pub type sev_cmd_id = u32;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_cmd {
    pub id: __u32,
    pub data: __u64,
    pub error: __u32,
    pub sev_fd: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_cmd() {
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_cmd>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_sev_cmd))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_cmd>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_cmd))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_cmd>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_cmd),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_cmd>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_cmd),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_cmd>())).error as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_cmd),
            "::",
            stringify!(error)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_cmd>())).sev_fd as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_cmd),
            "::",
            stringify!(sev_fd)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_launch_start {
    pub handle: __u32,
    pub policy: __u32,
    pub dh_uaddr: __u64,
    pub dh_len: __u32,
    pub session_uaddr: __u64,
    pub session_len: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_launch_start() {
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_launch_start>(),
        40usize,
        concat!("Size of: ", stringify!(kvm_sev_launch_start))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_launch_start>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_launch_start))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_launch_start>())).handle as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_launch_start>())).policy as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(policy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_launch_start>())).dh_uaddr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(dh_uaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_launch_start>())).dh_len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(dh_len)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_sev_launch_start>())).session_uaddr as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(session_uaddr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_sev_launch_start>())).session_len as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_start),
            "::",
            stringify!(session_len)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_launch_update_data {
    pub uaddr: __u64,
    pub len: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_launch_update_data() {
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_launch_update_data>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_sev_launch_update_data))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_launch_update_data>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_launch_update_data))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_sev_launch_update_data>())).uaddr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_update_data),
            "::",
            stringify!(uaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_launch_update_data>())).len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_update_data),
            "::",
            stringify!(len)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_launch_secret {
    pub hdr_uaddr: __u64,
    pub hdr_len: __u32,
    pub guest_uaddr: __u64,
    pub guest_len: __u32,
    pub trans_uaddr: __u64,
    pub trans_len: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_launch_secret() {
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_launch_secret>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_sev_launch_secret))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_launch_secret>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_launch_secret))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_launch_secret>())).hdr_uaddr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(hdr_uaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_launch_secret>())).hdr_len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(hdr_len)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_sev_launch_secret>())).guest_uaddr as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(guest_uaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_launch_secret>())).guest_len as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(guest_len)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_sev_launch_secret>())).trans_uaddr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(trans_uaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_launch_secret>())).trans_len as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_secret),
            "::",
            stringify!(trans_len)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_launch_measure {
    pub uaddr: __u64,
    pub len: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_launch_measure() {
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_launch_measure>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_sev_launch_measure))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_launch_measure>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_launch_measure))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_launch_measure>())).uaddr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_measure),
            "::",
            stringify!(uaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_launch_measure>())).len as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_launch_measure),
            "::",
            stringify!(len)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_guest_status {
    pub handle: __u32,
    pub policy: __u32,
    pub state: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_guest_status() {
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_guest_status>(),
        12usize,
        concat!("Size of: ", stringify!(kvm_sev_guest_status))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_guest_status>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_sev_guest_status))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_guest_status>())).handle as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_guest_status),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_guest_status>())).policy as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_guest_status),
            "::",
            stringify!(policy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_guest_status>())).state as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_guest_status),
            "::",
            stringify!(state)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_sev_dbg {
    pub src_uaddr: __u64,
    pub dst_uaddr: __u64,
    pub len: __u32,
}
#[test]
fn bindgen_test_layout_kvm_sev_dbg() {
    assert_eq!(
        ::std::mem::size_of::<kvm_sev_dbg>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_sev_dbg))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sev_dbg>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sev_dbg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_dbg>())).src_uaddr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_dbg),
            "::",
            stringify!(src_uaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_dbg>())).dst_uaddr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_dbg),
            "::",
            stringify!(dst_uaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_sev_dbg>())).len as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_sev_dbg),
            "::",
            stringify!(len)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_assigned_pci_dev {
    pub assigned_dev_id: __u32,
    pub busnr: __u32,
    pub devfn: __u32,
    pub flags: __u32,
    pub segnr: __u32,
    pub __bindgen_anon_1: kvm_assigned_pci_dev__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_assigned_pci_dev__bindgen_ty_1 {
    pub reserved: [__u32; 11usize],
    _bindgen_union_align: [u32; 11usize],
}
#[test]
fn bindgen_test_layout_kvm_assigned_pci_dev__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_assigned_pci_dev__bindgen_ty_1>(),
        44usize,
        concat!("Size of: ", stringify!(kvm_assigned_pci_dev__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_assigned_pci_dev__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_assigned_pci_dev__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_assigned_pci_dev__bindgen_ty_1>())).reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_pci_dev__bindgen_ty_1),
            "::",
            stringify!(reserved)
        )
    );
}
impl Default for kvm_assigned_pci_dev__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_assigned_pci_dev() {
    assert_eq!(
        ::std::mem::size_of::<kvm_assigned_pci_dev>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_assigned_pci_dev))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_assigned_pci_dev>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_assigned_pci_dev))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_assigned_pci_dev>())).assigned_dev_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_pci_dev),
            "::",
            stringify!(assigned_dev_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_assigned_pci_dev>())).busnr as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_pci_dev),
            "::",
            stringify!(busnr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_assigned_pci_dev>())).devfn as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_pci_dev),
            "::",
            stringify!(devfn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_assigned_pci_dev>())).flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_pci_dev),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_assigned_pci_dev>())).segnr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_pci_dev),
            "::",
            stringify!(segnr)
        )
    );
}
impl Default for kvm_assigned_pci_dev {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_assigned_irq {
    pub assigned_dev_id: __u32,
    pub host_irq: __u32,
    pub guest_irq: __u32,
    pub flags: __u32,
    pub __bindgen_anon_1: kvm_assigned_irq__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_assigned_irq__bindgen_ty_1 {
    pub reserved: [__u32; 12usize],
    _bindgen_union_align: [u32; 12usize],
}
#[test]
fn bindgen_test_layout_kvm_assigned_irq__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_assigned_irq__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_assigned_irq__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_assigned_irq__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_assigned_irq__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_assigned_irq__bindgen_ty_1>())).reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_irq__bindgen_ty_1),
            "::",
            stringify!(reserved)
        )
    );
}
impl Default for kvm_assigned_irq__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_assigned_irq() {
    assert_eq!(
        ::std::mem::size_of::<kvm_assigned_irq>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_assigned_irq))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_assigned_irq>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_assigned_irq))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_assigned_irq>())).assigned_dev_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_irq),
            "::",
            stringify!(assigned_dev_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_assigned_irq>())).host_irq as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_irq),
            "::",
            stringify!(host_irq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_assigned_irq>())).guest_irq as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_irq),
            "::",
            stringify!(guest_irq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_assigned_irq>())).flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_irq),
            "::",
            stringify!(flags)
        )
    );
}
impl Default for kvm_assigned_irq {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_assigned_msix_nr {
    pub assigned_dev_id: __u32,
    pub entry_nr: __u16,
    pub padding: __u16,
}
#[test]
fn bindgen_test_layout_kvm_assigned_msix_nr() {
    assert_eq!(
        ::std::mem::size_of::<kvm_assigned_msix_nr>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_assigned_msix_nr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_assigned_msix_nr>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_assigned_msix_nr))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_assigned_msix_nr>())).assigned_dev_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_msix_nr),
            "::",
            stringify!(assigned_dev_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_assigned_msix_nr>())).entry_nr as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_msix_nr),
            "::",
            stringify!(entry_nr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_assigned_msix_nr>())).padding as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_msix_nr),
            "::",
            stringify!(padding)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_assigned_msix_entry {
    pub assigned_dev_id: __u32,
    pub gsi: __u32,
    pub entry: __u16,
    pub padding: [__u16; 3usize],
}
#[test]
fn bindgen_test_layout_kvm_assigned_msix_entry() {
    assert_eq!(
        ::std::mem::size_of::<kvm_assigned_msix_entry>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_assigned_msix_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_assigned_msix_entry>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_assigned_msix_entry))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<kvm_assigned_msix_entry>())).assigned_dev_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_msix_entry),
            "::",
            stringify!(assigned_dev_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_assigned_msix_entry>())).gsi as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_msix_entry),
            "::",
            stringify!(gsi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_assigned_msix_entry>())).entry as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_msix_entry),
            "::",
            stringify!(entry)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_assigned_msix_entry>())).padding as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_assigned_msix_entry),
            "::",
            stringify!(padding)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_hyperv_eventfd {
    pub conn_id: __u32,
    pub fd: __s32,
    pub flags: __u32,
    pub padding: [__u32; 3usize],
}
#[test]
fn bindgen_test_layout_kvm_hyperv_eventfd() {
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_eventfd>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_hyperv_eventfd))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_eventfd>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_hyperv_eventfd))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_hyperv_eventfd>())).conn_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_eventfd),
            "::",
            stringify!(conn_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_hyperv_eventfd>())).fd as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_eventfd),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_hyperv_eventfd>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_eventfd),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<kvm_hyperv_eventfd>())).padding as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kvm_hyperv_eventfd),
            "::",
            stringify!(padding)
        )
    );
}
