(* cml-cleanup-sig.sml
 *
 * COPYRIGHT (c) 1996 AT&T Research.
 *
 * Log/unlog channels and servers for initialization and termination.
 *)

signature CML_CLEANUP =
  sig

    datatype when = AtInit | AtInitFn | AtShutdown | AtExit
	(* The CML clean-up times are somewhat different than the SML/NJ
	 * times.
	 *
	 *	AtInit		initialization of a program that is being run
	 *			under RunCML.doit.
	 *	AtInitFn	initialization of a stand-alone program that was
	 *			generated by exportFn.
	 *	AtShutdown	normal program exit of a CML program running
	 *			under RunCML.doit.
	 *	AtExit		normal program exit of a stand-alone CML program.
	 *
	 * Note that the clean-up routines run while CML is still active.  It
	 * may also be useful for an application to register clean-up routines
	 * with SML/NJ (AtExportFn actions are the most useful).
	 *)

    val atAll : when list
	(* at all times *)

    val addCleaner    : (string * when list * (when -> unit))
	  -> (when list * (when -> unit)) option
	(* add the named cleaner.  This returns the previous definition, or NONE. *)

    val removeCleaner : string -> (when list * (when -> unit)) option
	(* remove and return the named cleaner; return NONE if it is not found *)

    exception Unlog

    val logMailbox	: (string * 'a Mailbox.mbox) -> unit
    val unlogMailbox	: string -> unit

    val logChannel	: (string * 'a CML.chan) -> unit
    val unlogChannel	: string -> unit

(*
    val logServer	: (string * (when -> unit)) -> unit
*)
    val logServer	: (string * (unit -> unit) * (unit -> unit)) -> unit
    val unlogServer	: string -> unit

    val unlogAll	: unit -> unit

  end
