-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with ExaminerConstants;
with E_Strings;
with LexTokenManager;
with SPARK_IO;

use type LexTokenManager.Str_Comp_Result;

--# inherit ExaminerConstants,
--#         E_Strings,
--#         LexTokenManager,
--#         SPARK_IO,
--#         SystemErrors;

package LexTokenLists is

   subtype Lengths is Natural range 0 .. ExaminerConstants.Lex_Token_Lists_Max_Length;

   subtype Positions is Lengths range 1 .. ExaminerConstants.Lex_Token_Lists_Max_Length;

   type Lists is private;

   Null_List : constant Lists;

   function Prefix_Unit (Poss_Prefix, Prefixed : Lists) return Boolean;
   --# global in LexTokenManager.State;

   function Eq_Unit (First_Item, Second : Lists) return Boolean;
   --# global in LexTokenManager.State;

   procedure Append (List : in out Lists;
                     Item : in     LexTokenManager.Lex_String);
   --# derives List from *,
   --#                   Item;

   --  Write a dotted name identifier (List) to the standard output.
   procedure Print_List (File : in SPARK_IO.File_Type;
                         List : in Lists);
   --# global in     LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                File,
   --#                                LexTokenManager.State,
   --#                                List;

   function Token_List_To_String (Token_List : Lists) return E_Strings.T;
   --# global in LexTokenManager.State;

   function Get_Length (List : Lists) return Lengths;

   function Get_Element (List : Lists;
                         Pos  : Positions) return LexTokenManager.Lex_String;

   procedure Pop (List : in out Lists;
                  Item :    out LexTokenManager.Lex_String);
   --# derives Item,
   --#         List from List;

private

   type Contents is array (Positions) of LexTokenManager.Lex_String;

   type Lists is record
      Length  : Lengths;
      Content : Contents;
   end record;

   Null_List : constant Lists := Lists'(0, Contents'(Positions => LexTokenManager.Null_String));

end LexTokenLists;
