/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLQuery;
import adql.query.IdentifierField;
import adql.query.SelectItem;
import adql.query.from.ADQLTable;
import java.util.NoSuchElementException;

public final class SelectAllColumns
extends SelectItem {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "SELECT_ALL_COLUMNS", false, "A single item of the clause SELECT that selects all columns of all tables (or just the specified one).");
    private ADQLQuery query = null;
    private ADQLTable adqlTable = null;

    public SelectAllColumns(ADQLQuery query) {
        super(null, null);
        this.query = query;
    }

    public SelectAllColumns(ADQLTable table) {
        super(null, null);
        this.adqlTable = table;
    }

    public SelectAllColumns(SelectAllColumns toCopy) throws Exception {
        super(toCopy);
    }

    @Override
    public LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    public final ADQLQuery getQuery() {
        return this.query;
    }

    public final void setQuery(ADQLQuery query) {
        if (query != null) {
            this.query = query;
            this.adqlTable = null;
            this.setPosition(null);
        }
    }

    public final ADQLTable getAdqlTable() {
        return this.adqlTable;
    }

    public final void setAdqlTable(ADQLTable table) {
        if (table != null) {
            this.adqlTable = table;
            this.query = null;
            this.setPosition(null);
        }
    }

    @Override
    public final ADQLObject getCopy() throws Exception {
        return new SelectAllColumns(this);
    }

    @Override
    public final String getName() {
        return "*";
    }

    @Override
    public final ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean tableGot;
            {
                this.tableGot = SelectAllColumns.this.adqlTable == null;
            }

            @Override
            public ADQLObject next() throws NoSuchElementException {
                if (this.tableGot) {
                    throw new NoSuchElementException();
                }
                this.tableGot = true;
                return SelectAllColumns.this.adqlTable;
            }

            @Override
            public boolean hasNext() {
                return !this.tableGot;
            }

            @Override
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (replacer == null) {
                    this.remove();
                } else {
                    if (!this.tableGot) {
                        throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called!");
                    }
                    if (!(replacer instanceof ADQLTable)) {
                        throw new IllegalStateException("Impossible to replace an ADQLTable by a " + replacer.getClass().getName() + "!");
                    }
                    SelectAllColumns.this.adqlTable = (ADQLTable)replacer;
                    SelectAllColumns.this.setPosition(null);
                }
            }

            @Override
            public void remove() {
                if (!this.tableGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called!");
                }
                throw new UnsupportedOperationException("Impossible to remove the only operand (" + SelectAllColumns.this.adqlTable.toADQL() + ") from a SelectItem (" + SelectAllColumns.this.toADQL() + ")!");
            }
        };
    }

    @Override
    public final String toADQL() {
        if (this.adqlTable != null) {
            if (this.adqlTable.hasAlias()) {
                return (this.adqlTable.isCaseSensitive(IdentifierField.ALIAS) ? "\"" + this.adqlTable.getAlias() + "\"" : this.adqlTable.getAlias()) + ".*";
            }
            return this.adqlTable.getFullTableName() + ".*";
        }
        return "*";
    }
}

