C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE CMPTFV
C                       *****************
C
C     ----------------------------------
     *(NREFS,NREFE,NPOINS,NELEMS,NBFLVS)
C     ----------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             COMPTE DES FLUX VOLUMIQUES                               *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NREFS    ! TE ! D  ! REFERENCES DES NOEUDS SOLIDES                !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NREFE    ! TE ! D  ! REFERENCES DES ELEMENTS SOLIDES              !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELEMENTS DU MAILLAGE SOLIDE         !
C !  NBFLVS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC FLUX VOLUMIQUE !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) :
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "xrefer.h"
C
C***********************************************************************
C 
C.. Variables externes
      INTEGER NPOINS,NELEMS,NREFS(NPOINS),NREFE(NELEMS)
      INTEGER NBFLVS
C
C.. Variables internes
      INTEGER I,NUMREF,N1
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ------------------
C
      NBFLVS = 0
C
      IF (NDFLUV.EQ.1) THEN
C
       DO 100 I=1,NPOINS
C
        NUMREF = NREFS(I)
         IF (NUMREF.NE.0) THEN
          DO 105 N1=1,NRFMAX
C
            IF (IREFSV(N1).NE.0 .AND. NUMREF.EQ.N1) THEN
                NBFLVS = NBFLVS + 1
            ENDIF
C
  105     CONTINUE
        ENDIF
  100 CONTINUE
C
      ELSE 
C
       DO 110 I=1,NELEMS
C
        NUMREF = NREFE(I)
         IF (NUMREF.NE.0) THEN
          DO 115 N1=1,NRFMAX
C
            IF (IREFSV(N1).NE.0 .AND. NUMREF.EQ.N1) THEN
                NBFLVS = NBFLVS + 1
            ENDIF
C
  115     CONTINUE
        ENDIF
  110 CONTINUE
C
      ENDIF
C
      END
