/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export.compressors;

import org.web3d.vrml.export.compressors.BitPacker;

public class BitUnpacker {
    private int num_bits_remaining;
    private byte[] buffer;
    private int next_bit_to_read;

    public BitUnpacker(byte[] byArray) {
        this.num_bits_remaining = byArray.length * 8;
        this.buffer = byArray;
        this.next_bit_to_read = 0;
    }

    public int unpack(int n) {
        int n2 = 0;
        if (n > this.num_bits_remaining) {
            throw new RuntimeException("Trying to read more bits then are left in BitUnpacker");
        }
        this.num_bits_remaining -= n;
        int n3 = n < 32 ? -1 << n : Integer.MIN_VALUE;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        boolean bl2 = true;
        while (n > 0) {
            n4 = this.next_bit_to_read / 8;
            n5 = this.next_bit_to_read % 8;
            n6 = 1 << 7 - n5;
            n7 = 1 << n - 1;
            if ((this.buffer[n4] & n6) != 0) {
                if (bl2) {
                    bl = true;
                }
                n2 |= n7;
            }
            bl2 = false;
            --n;
            ++this.next_bit_to_read;
        }
        if (bl) {
            return n2 | n3;
        }
        return n2;
    }

    public void reset(byte[] byArray) {
        this.num_bits_remaining = byArray.length * 8;
        this.buffer = byArray;
        this.next_bit_to_read = 0;
    }

    public long getNumBitsRemaining() {
        return this.num_bits_remaining;
    }

    public static void main(String[] stringArray) {
        BitPacker bitPacker = new BitPacker(3);
        bitPacker.pack(0, 4);
        bitPacker.pack(82, 7);
        bitPacker.pack(69, 7);
        byte[] byArray = new byte[bitPacker.size()];
        bitPacker.getResult(byArray);
        BitUnpacker bitUnpacker = new BitUnpacker(byArray);
        System.out.println(bitUnpacker.unpack(4));
        System.out.println(bitUnpacker.unpack(7));
        System.out.println(bitUnpacker.unpack(7));
    }
}

