describe('fullscreen', function() {
    var map;

    beforeEach(function() {
        callbackResult = null;
        var div = document.createElement('div');
        div.style.width = '400px';
        div.style.height = '400px';

        map = new com.modestmaps.Map(div, new com.modestmaps.TemplatedMapProvider(
            'http://{S}tile.openstreetmap.org/{Z}/{X}/{Y}.png', ['a.']));
        map.setCenterZoom(new com.modestmaps.Location(37.811530, -122.2666097), 10);
        wax.mm.fullscreen(map).appendTo(map.parent);
    });

    it('makes the map fullscreen', function() {
        $('.wax-fullscreen', map.parent).click();
        expect($(map.parent).hasClass('wax-fullscreen-map')).toEqual(true);
    });

    it('can toggle fullscreen', function() {
        $('.wax-fullscreen', map.parent).click();
        expect($(map.parent).hasClass('wax-fullscreen-map')).toEqual(true);
        $('.wax-fullscreen', map.parent).click();
        expect($(map.parent).hasClass('wax-fullscreen-map')).toEqual(false);
    });
});
