/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: mpeg2.h,v 1.1 2000/02/05 11:23:41 rich Exp $
 */

#ifndef __mpeg2_h__
#define __mpeg2_h__

/* This file is the public interface to the MPEG2 decoder library. */

#define MPEG2_OUTPUT_FORMAT_RGB 1

/* Initialize the decoder library. You must call this once before
 * you call anything else in the library.
 */
extern void mpeg2Init (void);

/* Open the given MPEG-2 file. If this succeeds, it returns a pointer
 * to an opaque object which you must pass back into other calls to
 * the library. If it fails, it returns NULL.
 */
extern void *mpeg2OpenFile (const char *pathname);

/* Close the MPEG-2 file. */
extern void mpeg2CloseFile (void *m);

/* Select the output format required. */
extern void mpeg2SetOutputFormat (void *m, int format);

/* Select the output scale factor required. The MPEG-2 library
 * can scale up or down by any integer factor. When scaling down
 * it does sensible interpolation.
 * (NB: ``Up'' *increases* the image size by scale factor.)
 */
extern void mpeg2ScaleWidthUp (void *m, int width_scale);
extern void mpeg2ScaleWidthDown (void *m, int width_scale);
extern void mpeg2ScaleHeightUp (void *m, int height_scale);
extern void mpeg2ScaleHeightDown (void *m, int height_scale);

/* Read the actual width and height of the file. */
extern int mpeg2GetWidth (void *m);
extern int mpeg2GetHeight (void *m);

/* Set the address of the output buffer. You must always set this
 * before calling mpeg2ReadNextFrame.
 */
extern void mpeg2SetOutputBuffer (void *m, void *output_buffer);

/* Read the next frame into the output buffer. This function returns
 * 1 if there are more frames in the sequence, 0 if there are no
 * more frames in the sequence, and -1 if there was an unrecoverable
 * error.
 */
extern int mpeg2ReadNextFrame (void *m);

#endif /* __mpeg2_h__ */
