/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import vlcskineditor.Bezier;
import vlcskineditor.Helper;
import vlcskineditor.Item;
import vlcskineditor.Language;
import vlcskineditor.Main;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.ItemAddEvent;
import vlcskineditor.history.SliderEditEvent;
import vlcskineditor.items.SliderBackground;
import vlcskineditor.resources.ImageResource;

public class Slider
extends Item
implements ActionListener {
    public final String DOWN_DEFAULT = "none";
    public final String OVER_DEFAULT = "none";
    public final int THICKNESS_DEFAULT = 10;
    public final String VALUE_DEFAULT = "none";
    public final String TOOLTIPTEXT_DEFAULT = "none";
    public String up;
    public String down = "none";
    public String over = "none";
    public String points = "(0,0)";
    public int thickness = 10;
    public String value = "none";
    public String tooltiptext = "none";
    public SliderBackground sbg = null;
    boolean inPlaytree = false;
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField help_tf;
    JTextField visible_tf;
    JTextField up_tf;
    JTextField down_tf;
    JTextField over_tf;
    JTextField points_tf;
    JTextField thickness_tf;
    JTextField tooltiptext_tf;
    JComboBox lefttop_cb;
    JComboBox rightbottom_cb;
    JComboBox xkeepratio_cb;
    JComboBox ykeepratio_cb;
    JComboBox resize_cb;
    JComboBox action_cb;
    JComboBox value_cb;
    JCheckBox sbg_chb;
    JButton visible_btn;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    JButton sbg_btn;
    ImageResource up_res;
    ImageResource over_res;
    ImageResource down_res;
    Bezier b;
    int[] xpos;
    int[] ypos;
    private Point2D.Float sliderPos;
    private Point2D.Float[] bezierPoints;

    public Slider(Node node, Skin skin) {
        this.type = Language.get("SLIDER");
        this.s = skin;
        this.id = XML.getStringAttributeValue(node, "id", Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId())));
        this.up = XML.getStringAttributeValue(node, "up", this.up);
        this.down = XML.getStringAttributeValue(node, "down", this.down);
        this.over = XML.getStringAttributeValue(node, "over", this.over);
        this.points = XML.getStringAttributeValue(node, "points", this.points);
        this.thickness = XML.getIntAttributeValue(node, "thickness", this.thickness);
        this.value = XML.getStringAttributeValue(node, "value", this.value);
        this.x = XML.getIntAttributeValue(node, "x", this.x);
        this.y = XML.getIntAttributeValue(node, "y", this.y);
        this.lefttop = XML.getStringAttributeValue(node, "lefttop", this.lefttop);
        this.rightbottom = XML.getStringAttributeValue(node, "rightbottom", this.rightbottom);
        this.xkeepratio = XML.getBoolAttributeValue(node, "xkeepratio", this.xkeepratio);
        this.ykeepratio = XML.getBoolAttributeValue(node, "ykeepratio", this.ykeepratio);
        this.tooltiptext = XML.getStringAttributeValue(node, "tooltiptext", this.tooltiptext);
        this.visible = XML.getStringAttributeValue(node, "visible", this.visible);
        this.help = XML.getStringAttributeValue(node, "help", this.help);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals("SliderBackground")) continue;
            this.sbg = new SliderBackground(nodeList.item(i), this.s);
        }
        this.up_res = this.s.getImageResource(this.up);
        this.over_res = this.s.getImageResource(this.over);
        this.down_res = this.s.getImageResource(this.down);
        this.updateBezier();
        this.created = true;
    }

    public Slider(Node node, Skin skin, boolean bl) {
        this(node, skin);
        this.inPlaytree = bl;
    }

    public Slider(String string, Skin skin) {
        this.type = Language.get("SLIDER");
        this.s = skin;
        String[] stringArray = string.split("\n");
        this.up = XML.getValue(stringArray[0], "up");
        this.up_res = this.s.getImageResource(this.up);
        if (stringArray[0].indexOf(" down=\"") != -1) {
            this.down = XML.getValue(stringArray[0], "down");
            this.down_res = this.s.getImageResource(this.down);
        }
        if (stringArray[0].indexOf(" over=\"") != -1) {
            this.over = XML.getValue(stringArray[0], "over");
            this.over_res = this.s.getImageResource(this.over);
        }
        this.points = XML.getValue(stringArray[0], "points");
        this.updateBezier();
        if (stringArray[0].indexOf(" thickness=\"") != -1) {
            this.thickness = XML.getIntValue(stringArray[0], "thickness");
        }
        if (stringArray[0].indexOf(" value=\"") != -1) {
            this.value = XML.getValue(stringArray[0], "value");
        }
        if (stringArray[0].indexOf(" tooltiptext=\"") != -1) {
            this.tooltiptext = XML.getValue(stringArray[0], "tooltiptext");
        }
        if (stringArray[0].indexOf(" x=\"") != -1) {
            this.x = XML.getIntValue(stringArray[0], "x");
        }
        if (stringArray[0].indexOf(" y=\"") != -1) {
            this.y = XML.getIntValue(stringArray[0], "y");
        }
        this.id = stringArray[0].indexOf(" id=\"") != -1 ? XML.getValue(stringArray[0], "id") : Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        if (stringArray[0].indexOf(" lefttop=\"") != -1) {
            this.lefttop = XML.getValue(stringArray[0], "lefttop");
        }
        if (stringArray[0].indexOf(" rightbottom=\"") != -1) {
            this.rightbottom = XML.getValue(stringArray[0], "rightbottom");
        }
        if (stringArray[0].indexOf(" xkeepratio=\"") != -1) {
            this.xkeepratio = XML.getBoolValue(stringArray[0], "xkeepratio");
        }
        if (stringArray[0].indexOf(" ykeepratio=\"") != -1) {
            this.ykeepratio = XML.getBoolValue(stringArray[0], "ykeepratio");
        }
        if (string.indexOf(" visible=\"") != -1) {
            this.visible = XML.getValue(string, "visible");
        }
        if (stringArray.length > 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
                if (stringArray[i].startsWith("<!--")) {
                    while (stringArray[i].indexOf("-->") == -1) {
                        ++i;
                    }
                    continue;
                }
                if (!stringArray[i].startsWith("<SliderBackground")) continue;
                this.sbg = new SliderBackground(stringArray[i], this.s);
                break;
            }
        }
        this.created = true;
    }

    public Slider(String string, Skin skin, boolean bl) {
        this.type = Language.get("SLIDER");
        this.s = skin;
        String[] stringArray = string.split("\n");
        this.inPlaytree = bl;
        this.up = XML.getValue(stringArray[0], "up");
        this.up_res = this.s.getImageResource(this.up);
        if (stringArray[0].indexOf("down=\"") != -1) {
            this.down = XML.getValue(stringArray[0], "down");
        }
        if (stringArray[0].indexOf("over=\"") != -1) {
            this.over = XML.getValue(stringArray[0], "over");
        }
        this.points = XML.getValue(stringArray[0], "points");
        this.updateBezier();
        if (stringArray[0].indexOf("thickness=\"") != -1) {
            this.thickness = XML.getIntValue(stringArray[0], "thickness");
        }
        if (stringArray[0].indexOf("tooltiptext=\"") != -1) {
            this.tooltiptext = XML.getValue(stringArray[0], "tooltiptext");
        }
        if (stringArray[0].indexOf("x=\"") != -1) {
            this.x = XML.getIntValue(stringArray[0], "x");
        }
        if (stringArray[0].indexOf("y=\"") != -1) {
            this.y = XML.getIntValue(stringArray[0], "y");
        }
        this.id = stringArray[0].indexOf("id=\"") != -1 ? XML.getValue(stringArray[0], "id") : Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        if (stringArray[0].indexOf("lefttop=\"") != -1) {
            this.lefttop = XML.getValue(stringArray[0], "lefttop");
        }
        if (stringArray[0].indexOf("rightbottom=\"") != -1) {
            this.rightbottom = XML.getValue(stringArray[0], "rightbottom");
        }
        if (stringArray[0].indexOf("xkeepratio=\"") != -1) {
            this.xkeepratio = XML.getBoolValue(stringArray[0], "xkeepratio");
        }
        if (stringArray[0].indexOf("ykeepratio=\"") != -1) {
            this.xkeepratio = XML.getBoolValue(stringArray[0], "ykeepratio");
        }
        if (stringArray.length > 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("<SliderBackground")) continue;
                this.sbg = new SliderBackground(stringArray[i], this.s);
                break;
            }
        }
        this.created = true;
    }

    public Slider(Skin skin) {
        this.type = Language.get("SLIDER");
        this.s = skin;
        this.up = "none";
        this.id = Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        this.updateBezier();
        this.showOptions();
        this.s.updateItems();
        this.s.expandItem(this.id);
    }

    public Slider(Skin skin, boolean bl) {
        this.type = Language.get("SLIDER");
        this.s = skin;
        this.up = "none";
        this.id = Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        this.inPlaytree = bl;
        this.created = true;
    }

    public void updateBezier() {
        String[] stringArray = this.points.split("\\),\\(");
        this.xpos = new int[stringArray.length];
        this.ypos = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = string.split(",");
            this.xpos[i] = Integer.parseInt(stringArray2[0].replaceAll("\\(", "").trim());
            this.ypos[i] = Integer.parseInt(stringArray2[1].replaceAll("\\)", "").trim());
        }
        this.b = new Bezier(this.xpos, this.ypos, 0);
        this.sliderPos = this.b.getPoint(this.s.gvars.getSliderValue());
        this.bezierPoints = new Point2D.Float[11];
        for (float f = 0.0f; f <= 100.0f; f += 10.0f) {
            this.bezierPoints[(int)(f / 10.0f)] = this.b.getPoint(f / 100.0f);
        }
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.up = this.up_tf.getText();
            this.over = this.over_tf.getText();
            this.down = this.down_tf.getText();
            this.points = this.points_tf.getText();
            this.thickness = Integer.parseInt(this.thickness_tf.getText());
            if (!this.inPlaytree) {
                this.value = (String)this.value_cb.getSelectedItem();
            }
            this.tooltiptext = this.tooltiptext_tf.getText();
            this.updateBezier();
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.created = true;
            this.frame.setDefaultCloseOperation(2);
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
        } else {
            SliderEditEvent sliderEditEvent = new SliderEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.up = this.up_tf.getText();
            this.over = this.over_tf.getText();
            this.down = this.down_tf.getText();
            this.points = this.points_tf.getText();
            this.thickness = Integer.parseInt(this.thickness_tf.getText());
            if (!this.inPlaytree) {
                this.value = (String)this.value_cb.getSelectedItem();
            }
            this.tooltiptext = this.tooltiptext_tf.getText();
            this.updateBezier();
            this.s.updateItems();
            this.s.expandItem(this.id);
            sliderEditEvent.setNew();
            this.s.m.hist.addEvent(sliderEditEvent);
        }
        this.updateToGlobalVariables();
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            Object object;
            this.frame = new JFrame(Language.get("WIN_SLIDER_TITLE"));
            this.frame.setIconImage(Main.edit_icon.getImage());
            this.frame.setResizable(false);
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel(Language.get("WIN_ITEM_ID"));
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel(Language.get("WIN_ITEM_X"));
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel(Language.get("WIN_ITEM_Y"));
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            JLabel jLabel4 = new JLabel(Language.get("WIN_ITEM_LEFTTOP"));
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText(Language.get("WIN_ITEM_LEFTTOP_TIP"));
            JLabel jLabel5 = new JLabel(Language.get("WIN_ITEM_RIGHTBOTTOM"));
            this.rightbottom_cb = new JComboBox<String>(stringArray);
            this.rightbottom_cb.setToolTipText(Language.get("WIN_ITEM_RIGHTBOTTOM_TIP"));
            Object[] objectArray = new Object[]{true, false};
            JLabel jLabel6 = new JLabel(Language.get("WIN_ITEM_XKEEPRATIO"));
            this.xkeepratio_cb = new JComboBox<Object>(objectArray);
            this.xkeepratio_cb.setToolTipText(Language.get("WIN_ITEM_XKEEPRATIO_TIP"));
            JLabel jLabel7 = new JLabel(Language.get("WIN_ITEM_YKEEPRATIO"));
            this.ykeepratio_cb = new JComboBox<Object>(objectArray);
            this.ykeepratio_cb.setToolTipText(Language.get("WIN_ITEM_YKEEPRATIO_TIP"));
            JLabel jLabel8 = new JLabel(Language.get("WIN_ITEM_VISIBLE"));
            this.visible_tf = new JTextField();
            this.visible_btn = new JButton("", Main.help_icon);
            this.visible_btn.addActionListener(this);
            JLabel jLabel9 = new JLabel(Language.get("WIN_ITEM_HELP"));
            this.help_tf = new JTextField();
            this.help_tf.setToolTipText(Language.get("WIN_ITEM_HELP_TIP"));
            JLabel jLabel10 = new JLabel(Language.get("WIN_SLIDER_UP"));
            this.up_tf = new JTextField();
            JLabel jLabel11 = new JLabel(Language.get("WIN_SLIDER_OVER"));
            this.over_tf = new JTextField();
            JLabel jLabel12 = new JLabel(Language.get("WIN_SLIDER_DOWN"));
            this.down_tf = new JTextField();
            JLabel jLabel13 = new JLabel(Language.get("WIN_SLIDER_POINTS"));
            this.points_tf = new JTextField();
            JLabel jLabel14 = new JLabel(Language.get("WIN_SLIDER_THICKNESS"));
            this.thickness_tf = new JTextField();
            JLabel jLabel15 = new JLabel(Language.get("WIN_SLIDER_VALUE"));
            if (this.inPlaytree) {
                object = new String[]{Language.get("WIN_SLIDER_VALUE_SCROLL")};
                this.value_cb = new JComboBox<String>((E[])object);
            } else {
                object = new String[]{"time", "volume", "equalizer.preamp", "equalizer.band(0)", "equalizer.band(1)", "equalizer.band(2)", "equalizer.band(3)", "equalizer.band(4)", "equalizer.band(5)", "equalizer.band(6)", "equalizer.band(7)", "equalizer.band(8)", "equalizer.band(9)"};
                this.value_cb = new JComboBox<String>((E[])object);
            }
            object = new JLabel(Language.get("WIN_ITEM_TOOLTIPTEXT"));
            this.tooltiptext_tf = new JTextField();
            this.sbg_chb = new JCheckBox(Language.get("WIN_SLIDER_BG_ENABLE"));
            this.sbg_chb.addActionListener(this);
            this.sbg_btn = new JButton(Language.get("WIN_SLIDER_BG_EDIT"));
            this.sbg_btn.addActionListener(this);
            JLabel jLabel16 = new JLabel(Language.get("NOTE_STARRED"));
            this.ok_btn = new JButton(Language.get("BUTTON_OK"));
            this.ok_btn.addActionListener(this);
            this.cancel_btn = new JButton(Language.get("BUTTON_CANCEL"));
            this.cancel_btn.addActionListener(this);
            this.help_btn = new JButton(Language.get("BUTTON_HELP"));
            this.help_btn.addActionListener(this);
            Component[] componentArray = new Component[]{jLabel, jLabel2, jLabel3, jLabel4, jLabel5, jLabel6, jLabel7, jLabel8, jLabel9, jLabel10, jLabel11, jLabel12, jLabel13, jLabel14, object, jLabel15};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            JPanel jPanel = new JPanel();
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            this.id_tf.setPreferredSize(new Dimension(n2, this.id_tf.getPreferredSize().height));
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            jPanel.add(jLabel4);
            jPanel.add(this.lefttop_cb);
            jPanel.add(jLabel5);
            jPanel.add(this.rightbottom_cb);
            jPanel.add(jLabel6);
            jPanel.add(this.xkeepratio_cb);
            jPanel.add(jLabel7);
            jPanel.add(this.ykeepratio_cb);
            jPanel.add(jLabel8);
            jPanel.add(this.visible_tf);
            jPanel.add(this.visible_btn);
            jPanel.add(jLabel9);
            jPanel.add(this.help_tf);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_ITEM_GENERAL")));
            SpringLayout springLayout = new SpringLayout();
            jPanel.setLayout(springLayout);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.id_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("North", (Component)jLabel2, 10, "South", (Component)this.id_tf);
            springLayout.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.x_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)this.x_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.x_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel3, 10, "South", (Component)this.x_tf);
            springLayout.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.y_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout.putConstraint("West", (Component)this.y_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.y_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel4, 10, "South", (Component)this.y_tf);
            springLayout.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.lefttop_cb, 0, "VerticalCenter", (Component)jLabel4);
            springLayout.putConstraint("West", (Component)this.lefttop_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.lefttop_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel5, 10, "South", (Component)this.lefttop_cb);
            springLayout.putConstraint("West", (Component)jLabel5, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.rightbottom_cb, 0, "VerticalCenter", (Component)jLabel5);
            springLayout.putConstraint("West", (Component)this.rightbottom_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.rightbottom_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel6, 10, "South", (Component)this.rightbottom_cb);
            springLayout.putConstraint("West", (Component)jLabel6, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.xkeepratio_cb, 0, "VerticalCenter", (Component)jLabel6);
            springLayout.putConstraint("West", (Component)this.xkeepratio_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.xkeepratio_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel7, 10, "South", (Component)this.xkeepratio_cb);
            springLayout.putConstraint("West", (Component)jLabel7, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.ykeepratio_cb, 0, "VerticalCenter", (Component)jLabel7);
            springLayout.putConstraint("West", (Component)this.ykeepratio_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.ykeepratio_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel8, 10, "South", (Component)this.ykeepratio_cb);
            springLayout.putConstraint("West", (Component)jLabel8, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.visible_tf, 0, "VerticalCenter", (Component)jLabel8);
            springLayout.putConstraint("West", (Component)this.visible_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.visible_tf, -5, "West", (Component)this.visible_btn);
            springLayout.putConstraint("VerticalCenter", (Component)this.visible_btn, 0, "VerticalCenter", (Component)jLabel8);
            springLayout.putConstraint("East", (Component)this.visible_btn, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel9, 10, "South", (Component)this.visible_btn);
            springLayout.putConstraint("West", (Component)jLabel9, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.help_tf, 0, "VerticalCenter", (Component)jLabel9);
            springLayout.putConstraint("West", (Component)this.help_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.help_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.id_tf);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)this.help_tf);
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(jLabel10);
            jPanel2.add(this.up_tf);
            this.up_tf.setPreferredSize(new Dimension(n2, this.id_tf.getPreferredSize().height));
            jPanel2.add(jLabel11);
            jPanel2.add(this.over_tf);
            jPanel2.add(jLabel12);
            jPanel2.add(this.down_tf);
            jPanel2.add(jLabel13);
            jPanel2.add(this.points_tf);
            jPanel2.add(jLabel14);
            jPanel2.add(this.thickness_tf);
            jPanel2.add(jLabel15);
            jPanel2.add(this.value_cb);
            jPanel2.add((Component)object);
            jPanel2.add(this.tooltiptext_tf);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_SLIDER_ATTR")));
            SpringLayout springLayout2 = new SpringLayout();
            jPanel2.setLayout(springLayout2);
            springLayout2.putConstraint("North", (Component)jLabel10, 5, "North", (Component)jPanel2);
            springLayout2.putConstraint("West", (Component)jLabel10, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.up_tf, 0, "VerticalCenter", (Component)jLabel10);
            springLayout2.putConstraint("West", (Component)this.up_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("North", (Component)jLabel11, 10, "South", (Component)this.up_tf);
            springLayout2.putConstraint("West", (Component)jLabel11, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.over_tf, 0, "VerticalCenter", (Component)jLabel11);
            springLayout2.putConstraint("West", (Component)this.over_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.over_tf, 0, "East", (Component)this.up_tf);
            springLayout2.putConstraint("North", (Component)jLabel12, 10, "South", (Component)this.over_tf);
            springLayout2.putConstraint("West", (Component)jLabel12, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.down_tf, 0, "VerticalCenter", (Component)jLabel12);
            springLayout2.putConstraint("West", (Component)this.down_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.down_tf, 0, "East", (Component)this.up_tf);
            springLayout2.putConstraint("North", (Component)jLabel13, 10, "South", (Component)this.down_tf);
            springLayout2.putConstraint("West", (Component)jLabel13, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.points_tf, 0, "VerticalCenter", (Component)jLabel13);
            springLayout2.putConstraint("West", (Component)this.points_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.points_tf, 0, "East", (Component)this.up_tf);
            springLayout2.putConstraint("North", (Component)jLabel14, 10, "South", (Component)this.points_tf);
            springLayout2.putConstraint("West", (Component)jLabel14, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.thickness_tf, 0, "VerticalCenter", (Component)jLabel14);
            springLayout2.putConstraint("West", (Component)this.thickness_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.thickness_tf, 0, "East", (Component)this.up_tf);
            springLayout2.putConstraint("North", (Component)jLabel15, 10, "South", (Component)this.thickness_tf);
            springLayout2.putConstraint("West", (Component)jLabel15, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.value_cb, 0, "VerticalCenter", (Component)jLabel15);
            springLayout2.putConstraint("West", (Component)this.value_cb, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.value_cb, 0, "East", (Component)this.up_tf);
            springLayout2.putConstraint("North", (Component)object, 10, "South", (Component)this.value_cb);
            springLayout2.putConstraint("West", (Component)object, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.tooltiptext_tf, 0, "VerticalCenter", (Component)object);
            springLayout2.putConstraint("West", (Component)this.tooltiptext_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.tooltiptext_tf, 0, "East", (Component)this.up_tf);
            springLayout2.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.up_tf);
            springLayout2.putConstraint("South", (Component)jPanel2, 10, "South", (Component)this.tooltiptext_tf);
            this.frame.add(jPanel2);
            JPanel jPanel3 = new JPanel(null);
            jPanel3.add(this.sbg_chb);
            jPanel3.add(this.sbg_btn);
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_SLIDER_BG")));
            SpringLayout springLayout3 = new SpringLayout();
            jPanel3.setLayout(springLayout3);
            springLayout3.putConstraint("North", (Component)this.sbg_chb, 5, "North", (Component)jPanel3);
            springLayout3.putConstraint("West", (Component)this.sbg_chb, 5, "West", (Component)jPanel3);
            springLayout3.putConstraint("North", (Component)this.sbg_btn, 5, "North", (Component)jPanel3);
            springLayout3.putConstraint("West", (Component)this.sbg_btn, 5, "East", (Component)this.sbg_chb);
            springLayout3.putConstraint("East", (Component)jPanel3, 5, "East", (Component)this.sbg_btn);
            springLayout3.putConstraint("South", (Component)jPanel3, 10, "South", (Component)this.sbg_btn);
            this.frame.add(jPanel3);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(jLabel16);
            SpringLayout springLayout4 = new SpringLayout();
            springLayout4.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.frame.getContentPane());
            springLayout4.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.frame.getContentPane());
            springLayout4.putConstraint("North", (Component)jPanel2, 10, "South", (Component)jPanel);
            springLayout4.putConstraint("West", (Component)jPanel2, 5, "West", (Component)this.frame.getContentPane());
            springLayout4.putConstraint("North", (Component)jPanel3, 10, "South", (Component)jPanel2);
            springLayout4.putConstraint("West", (Component)jPanel3, 5, "West", (Component)this.frame.getContentPane());
            springLayout4.putConstraint("East", (Component)jPanel3, 0, "East", (Component)jPanel);
            springLayout4.putConstraint("North", (Component)jLabel16, 10, "South", (Component)jPanel3);
            springLayout4.putConstraint("West", (Component)jLabel16, 5, "West", (Component)this.frame.getContentPane());
            springLayout4.putConstraint("North", (Component)this.ok_btn, 10, "South", (Component)jLabel16);
            springLayout4.putConstraint("West", (Component)this.ok_btn, 5, "West", (Component)this.frame.getContentPane());
            springLayout4.putConstraint("North", (Component)this.cancel_btn, 0, "North", (Component)this.ok_btn);
            springLayout4.putConstraint("West", (Component)this.cancel_btn, 5, "East", (Component)this.ok_btn);
            springLayout4.putConstraint("North", (Component)this.help_btn, 0, "North", (Component)this.cancel_btn);
            springLayout4.putConstraint("West", (Component)this.help_btn, 5, "East", (Component)this.cancel_btn);
            springLayout4.putConstraint("South", (Component)this.frame.getContentPane(), 10, "South", (Component)this.ok_btn);
            springLayout4.putConstraint("East", (Component)this.frame.getContentPane(), 5, "East", (Component)jPanel);
            this.frame.setLayout(springLayout4);
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.rightbottom_cb.setSelectedItem(this.rightbottom);
        this.xkeepratio_cb.setSelectedItem(this.xkeepratio);
        this.ykeepratio_cb.setSelectedItem(this.ykeepratio);
        this.visible_tf.setText(this.visible);
        this.help_tf.setText(this.help);
        this.up_tf.setText(this.up);
        this.over_tf.setText(this.over);
        this.down_tf.setText(this.down);
        this.thickness_tf.setText(String.valueOf(this.thickness));
        this.points_tf.setText(this.points);
        if (!this.inPlaytree) {
            this.value_cb.setSelectedItem(this.value);
        }
        this.tooltiptext_tf.setText(this.tooltiptext);
        this.sbg_chb.setSelected(this.sbg != null);
        this.sbg_btn.setEnabled(this.sbg != null);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_INVALID_MSG"), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_EXISTS_MSG").replaceAll("%i", this.id_tf.getText()), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            this.up_res = this.s.getImageResource(this.up_tf.getText());
            if (this.up_res == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.up_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.up_res = this.s.getImageResource(this.up);
                return;
            }
            this.over_res = this.s.getImageResource(this.over_tf.getText());
            if (!this.over_tf.getText().equals("none") && this.over_res == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.over_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.over_res = this.s.getImageResource(this.over);
                return;
            }
            this.down_res = this.s.getImageResource(this.down_tf.getText());
            if (!this.down_tf.getText().equals("none") && this.down_res == null) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_BITMAP_NEXIST").replaceAll("%i", this.down_tf.getText()), Language.get("ERROR_BITMAP_NEXIST_TITLE"), 1);
                this.down_res = this.s.getImageResource(this.down);
                return;
            }
            if (this.points_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_POINTS_INVALID"), Language.get("ERROR_POINTS_INVALID_TITLE"), 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/i-slider.html");
        } else if (actionEvent.getSource().equals(this.sbg_chb)) {
            if (this.sbg_chb.isSelected()) {
                this.sbg = new SliderBackground(this.s, this);
                this.sbg_btn.setEnabled(true);
            } else {
                this.sbg = null;
                this.sbg_btn.setEnabled(false);
            }
        } else if (actionEvent.getSource().equals(this.sbg_btn)) {
            if (this.sbg != null) {
                this.sbg.showOptions();
            }
        } else if (actionEvent.getSource().equals(this.visible_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/i-slider.html");
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    public void removeBG() {
        if (this.sbg == null) {
            return;
        }
        this.sbg = null;
        this.sbg_chb.setSelected(false);
        this.sbg_btn.setEnabled(false);
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Slider";
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        string2 = string2 + " points=\"" + this.points + "\"";
        if (this.thickness != 10) {
            string2 = string2 + " thickness=\"" + String.valueOf(this.thickness) + "\"";
        }
        if (!this.inPlaytree && !this.value.equals("none")) {
            string2 = string2 + " value=\"" + this.value + "\"";
        }
        if (!this.tooltiptext.equals("none")) {
            string2 = string2 + " tooltiptext=\"" + this.tooltiptext + "\"";
        }
        string2 = string2 + " up=\"" + this.up + "\"";
        if (!this.down.equals("none")) {
            string2 = string2 + " down=\"" + this.down + "\"";
        }
        if (!this.over.equals("none")) {
            string2 = string2 + " over=\"" + this.over + "\"";
        }
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        if (!this.rightbottom.equals("lefttop")) {
            string2 = string2 + " rightbottom=\"" + this.rightbottom + "\"";
        }
        if (this.xkeepratio) {
            string2 = string2 + " xkeepratio=\"" + String.valueOf(this.xkeepratio) + "\"";
        }
        if (this.ykeepratio) {
            string2 = string2 + " ykeepratio=\"" + String.valueOf(this.ykeepratio) + "\"";
        }
        if (!this.help.equals("")) {
            string2 = string2 + " help=\"" + this.help + "\"";
        }
        if (!this.visible.equals("true")) {
            string2 = string2 + " visible=\"" + this.visible + "\"";
        }
        if (this.sbg == null) {
            string2 = string2 + "/>";
        } else {
            string2 = string2 + ">\n" + this.sbg.returnCode(string + Skin.indentation);
            string2 = string2 + "\n" + string + "</Slider>";
        }
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, 0, 0, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        if (!this.created) {
            return;
        }
        this.offsetx = n;
        this.offsety = n2;
        if (this.sbg != null && this.vis) {
            this.sbg.setOffset(this.x + n, this.y + n2);
            this.sbg.draw(graphics2D, this.x + n, this.y + n2, n3);
        }
        BufferedImage bufferedImage = this.up_res.image;
        if (this.vis && bufferedImage != null) {
            graphics2D.drawImage(bufferedImage, (int)(this.sliderPos.getX() + (double)this.x + (double)n - (double)(bufferedImage.getWidth() / 2)) * n3, (int)(this.sliderPos.getY() + (double)this.y + (double)n2 - (double)(bufferedImage.getHeight() / 2)) * n3, bufferedImage.getWidth() * n3, bufferedImage.getHeight() * n3, null);
        }
        if (this.selected) {
            int n4;
            graphics2D.setColor(Color.RED);
            for (n4 = 0; n4 < 10; ++n4) {
                Point2D.Float float_ = this.bezierPoints[n4];
                Point2D.Float float_2 = this.bezierPoints[n4 + 1];
                graphics2D.drawLine((int)(float_.getX() + (double)this.x + (double)n) * n3, (int)(float_.getY() + (double)this.y + (double)n2) * n3, (int)(float_2.getX() + (double)this.x + (double)n) * n3, (int)(float_2.getY() + (double)this.y + (double)n2) * n3);
            }
            graphics2D.setColor(Color.ORANGE);
            for (n4 = 0; n4 < this.xpos.length; ++n4) {
                graphics2D.fillOval((this.xpos[n4] + this.x + n - 1) * n3, (this.ypos[n4] + this.y + n2 - 1) * n3, 3, 3);
            }
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        int n3 = this.b.getHeight();
        int n4 = this.b.getWidth();
        return n >= this.x + this.offsetx && n <= this.x + this.offsetx + n4 && n2 >= this.y + this.offsety && n2 <= this.y + this.offsety + n3;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Slider: " + this.id);
        if (this.sbg != null) {
            defaultMutableTreeNode.add(this.sbg.getTreeNode());
        }
        return defaultMutableTreeNode;
    }

    @Override
    public Item getItem(String string) {
        if (this.id.equals(string)) {
            return this;
        }
        if (this.sbg == null) {
            return null;
        }
        if (this.sbg.id.equals(string)) {
            return this.sbg;
        }
        return null;
    }

    @Override
    public Item getParentOf(String string) {
        if (this.sbg != null) {
            if (this.sbg.id.equals(string)) {
                return this;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean uses(String string) {
        return this.sbg != null && this.sbg.uses(string) || this.up.equals(string) || this.over.equals(string) || this.down.equals(string);
    }

    @Override
    public void renameForCopy(String string) {
        String string2 = string;
        super.renameForCopy(string);
        if (this.sbg != null) {
            this.sbg.renameForCopy(string2);
        }
    }

    @Override
    public void updateToGlobalVariables() {
        this.vis = this.s.gvars.parseBoolean(this.visible);
        this.updateBezier();
        if (this.sbg != null) {
            this.sbg.updateToGlobalVariables();
        }
    }

    public boolean isInPlaytree() {
        return this.inPlaytree;
    }
}

