/*****************************************************************************
 * Bitmaps.h
 *****************************************************************************
 * Copyright (C) 2001 VideoLAN
 * $Id: Bitmaps.h,v 1.2 2002/09/30 18:30:27 titer Exp $
 *
 * Authors: Tony Castley <tcastley@mail.powerup.com.au>
 *          Stephan Aßmus <stippi@yellowbites.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

/*****************************************************************************
 * The button images have all bin updated to be consitent with Be's current
 * MediaPlayer, SoundRecorder and CDBurner. Errors in the original
 * bitmaps have been fixed, these images should be of perfect quality.
 *
 * To generate the bitmaps, they have been converted into B_CMAP8 color
 * space, loaded into QuickRes and Dumped as source code. This means
 * that any padding in the original bitmaps (bytes per row != width)
 * is still contained within this raw data. Thus, when the data is copied
 * into a BBitmap object of the exact same size, it is sufficient
 * to memcpy(bitmap->Bits(), kBitmapBits, bitmap->BitsLength())
 *
 * How can this be improved? It would be nice if Transport buttons would
 * not be drawn with static bitmaps. They could all use the same combination
 * of bitmaps for left and right borders, fill up the remaining part in the
 * middle and draw the specific transport icon on top of it all. The bitmaps
 * used for the left and right part of the button could be generated on the
 * fly by using a grey scale bitmap that is tinted with the appropriate
 * background view color (currently grey 216).
 *****************************************************************************/

#ifndef BEOS_BITMAPS_H
#define BEOS_BITMAPS_H

const unsigned char eject16x11_raw[] = {
0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0x00,0x17,0x18,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0x00,0x17,0x17,0x18,0x17,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x00,0x17,0x18,0x17,0x18,0x17,0x17,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x17,0x18,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff};
const unsigned char pause16x10_raw[] = {
0x00,0x00,0x00,0x00,0x3f,0xff,0xff,0x00,0x00,0x00,0x00,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x3f,0x3f,0x3f,0x3f,0xff,0xff,0x00,0x3f,0x3f,0x3f,0x3f,0xff,0xff,0xff,0xff};
const unsigned char play16x10_raw[] = {
0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x18,0x17,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x18,0x17,0x18,0x17,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x18,0x17,0x17,0x18,0x17,0x18,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x17,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x17,0x17,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};
const unsigned char skipleft24x8_raw[] = {
0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,
0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x3f,
0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0x00,0x00,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0x00,0x00,0x17,0x18,0x17,
0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x17,0x18,0x17,0x17,0x3f,
0xff,0x00,0x00,0x17,0x18,0x17,0x18,0x17,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x3f,0x3f,0x17,0x17,0x18,0x17,0x17,0x3f,0xff,0x3f,0x3f,0x17,0x17,0x18,0x17,0x17,
0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0x17,0x17,0x18,0x3f,
0xff,0xff,0xff,0x3f,0x3f,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0x3f,0x3f,0x17,0x3f,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0x17,
0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff};
const unsigned char skipright24x8_raw[] = {
0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x00,0x00,0xff,0xff,0xff,0xff,
0xff,0x00,0x18,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x00,0x00,0xff,0xff,0xff,0x00,0x18,0x17,0x17,0x00,0x00,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x18,0x17,0x17,0x00,0x00,
0xff,0x00,0x17,0x18,0x17,0x17,0x18,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x17,0x17,0x3f,0x3f,0xff,0x00,0x17,0x18,0x17,0x18,0x17,0x3f,
0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0x3f,0xff,0xff,
0xff,0x00,0x17,0x18,0x17,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0x00,0x17,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x3f,0x3f,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};
const unsigned char skiptrackleft24x8_raw[] = {
0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,0xff,0x00,
0x00,0x17,0x3f,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x17,0x3f,0xff,0xff,0xff,0xff,
0x00,0x3f,0xff,0xff,0xff,0x00,0x00,0x17,0x18,0x17,0x3f,0xff,0xff,0xff,0x00,0x00,
0x17,0x18,0x17,0x3f,0xff,0xff,0xff,0xff,0x00,0x3f,0xff,0x00,0x00,0x17,0x18,0x17,
0x18,0x17,0x3f,0xff,0x00,0x00,0x17,0x18,0x17,0x18,0x17,0x3f,0xff,0xff,0xff,0xff,
0x00,0x3f,0xff,0x3f,0x3f,0x17,0x17,0x18,0x17,0x17,0x3f,0xff,0x3f,0x3f,0x17,0x17,
0x18,0x17,0x17,0x3f,0xff,0xff,0xff,0xff,0x00,0x3f,0xff,0xff,0xff,0x3f,0x3f,0x17,
0x17,0x18,0x3f,0xff,0xff,0xff,0x3f,0x3f,0x17,0x17,0x18,0x3f,0xff,0xff,0xff,0xff,
0x00,0x3f,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0x17,0x3f,0xff,0xff,0xff,0xff,0xff,
0x3f,0x3f,0x17,0x3f,0xff,0xff,0xff,0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0xff,0xff,0xff,0xff};
const unsigned char skiptrackright24x8_raw[] = {
0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x17,0x00,0x00,0xff,0xff,0xff,0xff,
0xff,0x00,0x18,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x00,0x00,0xff,0xff,0xff,0x00,0x18,0x17,0x17,0x00,0x00,0xff,
0xff,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x18,0x17,0x17,0x00,0x00,
0xff,0x00,0x17,0x18,0x17,0x17,0x18,0x00,0x00,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x17,0x18,0x17,0x17,0x3f,0x3f,0xff,0x00,0x17,0x18,0x17,0x18,0x17,0x3f,
0x3f,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,0x00,0x17,0x17,0x18,0x3f,0x3f,0xff,0xff,
0xff,0x00,0x17,0x18,0x17,0x3f,0x3f,0xff,0xff,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,
0x00,0x17,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0x00,0x17,0x3f,0x3f,0xff,0xff,0xff,
0xff,0xff,0x00,0x3f,0xff,0xff,0xff,0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x3f,0x3f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x3f,0x3f,0xff,0xff,0xff,0xff};
const unsigned char stop8x8_raw[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x3f,
0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x3f,0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x3f,
0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x3f,0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x3f,
0x00,0x17,0x17,0x18,0x17,0x17,0x18,0x3f,0x00,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f};
const unsigned char LCDLarge96x16_raw[] = {
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x8d,0x21,0x21,0x22,0x21,0x8d,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,
0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,0x21,0x8d,0xff,0xff,0xff,0xff,0x8d,0x22,
0x21,0x8d,0x21,0x21,0x22,0x21,0x8d,0xff,0x22,0x8d,0x21,0x21,0x22,0x21,0x8d,0xff,
0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,0x21,0x8d,0x21,0x22,0x21,0x21,0x8d,0x22,
0x21,0x8d,0x21,0x22,0x21,0x21,0x8d,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0xff,0x22,0x8d,0xff,0xff,0xff,0xff,0x8d,0x22,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,
0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,0x21,0x8d,0x21,0x22,0x21,0x21,0x8d,0x22,
0x21,0x8d,0x21,0x22,0x21,0x21,0xff,0xff,0x22,0x8d,0x21,0x21,0x22,0x21,0x8d,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0x21,0x8d,0x21,0x21,0x22,0x21,0x8d,0x21,
0x22,0x8d,0x21,0x21,0x22,0x21,0x8d,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0x8d,0xff,0xff,0xff,0xff,0xff,0xff,0x8d,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x8d,0x22,0x21,0x21,0x21,0x22,0x21,0x8d,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0x8d,0x8d,0x21,0x22,0x21,0x21,0x22,0x21,0x8d,
0x8d,0x21,0x22,0x21,0x21,0x22,0x21,0x8d,0x8d,0x21,0x21,0x22,0x21,0x21,0x22,0x8d,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x8d,0x22,0x21,0x21,0x21,0x22,0x21,0x8d,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0x8d,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x8d,0xff,0xff,0xff,0xff,0x8d,0x22,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0x21,0x8d,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0x21,0x8d,0xff,0xff,0xff,0xff,0x8d,0x22,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0x21,0x8d,0xff,0xff,0xff,0xff,0x8d,0x22,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x8d,0x21,0x21,0x22,0x21,0x8d,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0x21,0x8d,0x21,0x21,0x22,0x21,0xff,0xff,
0xff,0xff,0x22,0x21,0x21,0x22,0x8d,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,
0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,0x21,0x8d,0x21,0x22,0x21,0x21,0x8d,0x22,
0xff,0xff,0xff,0xff,0xff,0xff,0x8d,0x22,0x21,0x8d,0x21,0x21,0x22,0x21,0x8d,0x21,
0xff,0x8d,0x22,0x21,0x21,0x22,0x8d,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,
0xff,0x22,0x21,0x21,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};
const unsigned char LCDMedium64x9_raw[] = {
0xff,0xff,0xff,0xff,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0x34,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x34,0x34,0x34,0xff,0x8d,0xff,0xff,0xff,0x8d,0xff,0xff,0xff,0xff,0x8d,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0x8d,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0x34,0x34,
0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0x34,0x34,0x34,0xff,0xff,0x34,0x34,0x34,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
};
const unsigned char LCDsmall64x8_raw[] = {
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0x22,0xff,
0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0x22,0xff,0xff,0xff,0x22,0xff,0x22,
0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0x22,0x21,0x21,0x22,0xff,0xff,0x22,0x21,
0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,
0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0x22,0x21,0xff,
0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,
0xff,0x22,0x21,0xff,0xff,0xff,0x22,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,
0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,0xff,0x22,0x21,0xff,
0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,
0xff,0x22,0x21,0xff,0xff,0xff,0x22,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0x22,0x21,0x21,0xff,0x8d,0xff,0xff,0xff,0x8d,0xff,0xff,0xff,0xff,0x8d,0xff,
0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0x22,
0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0x8d,0xff,0x22,0x21,
0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,
0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,0xff,
0xff,0xff,0x22,0x21,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,
0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,0xff,
0xff,0xff,0x22,0x21,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,
0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,
0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,0xff,
0xff,0xff,0x22,0x21,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0x22,0x21,0xff,0xff,
0xff,0x22,0xff,0xff,0xff,0xff,0x22,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
0xff,0xff,0xff,0xff,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0x22,0xff,
0x22,0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0x22,0xff,0x22,
0x21,0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0x22,0xff,0x22,0x21,
0x21,0xff,0xff,0x22,0x21,0x21,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff
};

const int32 kSpeakerIconBitmapWidth = 16;
const int32 kSpeakerIconBitmapHeight = 9;
const BPoint kSpeakerButtonSize(kSpeakerIconBitmapWidth - 1, kSpeakerIconBitmapHeight - 1);


const unsigned char kSpeakerIconBits [] = {
	0xff,0xff,0xff,0xff,0xff,0x10,0x10,0xff,0xff,0xff,0xff,0x10,0xff,0xff,0xff,0xff,
	0x10,0x10,0x10,0xff,0x10,0x1d,0x10,0xff,0xff,0xff,0xff,0xff,0x10,0xff,0xff,0xff,
	0x10,0x1d,0x10,0x10,0x1d,0x1d,0x10,0xff,0xff,0x10,0xff,0xff,0x10,0xff,0xff,0xff,
	0x10,0x1d,0x10,0x1d,0x1d,0x1d,0x10,0xff,0xff,0xff,0x10,0xff,0xff,0x10,0xff,0xff,
	0x10,0x1d,0x10,0x1d,0x1d,0x1d,0x10,0xff,0x10,0xff,0x10,0xff,0xff,0x10,0xff,0xff,
	0x10,0x1d,0x10,0x1d,0x1d,0x1d,0x10,0xff,0xff,0xff,0x10,0xff,0xff,0x10,0xff,0xff,
	0x10,0x1d,0x10,0x10,0x1d,0x1d,0x10,0xff,0xff,0x10,0xff,0xff,0x10,0xff,0xff,0xff,
	0x10,0x10,0x10,0xff,0x10,0x1d,0x10,0xff,0xff,0xff,0xff,0xff,0x10,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x10,0x10,0xff,0xff,0xff,0xff,0x10,0xff,0xff,0xff,0xff,
};

const unsigned char kPressedSpeakerIconBits [] = {
	0xff,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,
	0x34,0x34,0x34,0xff,0x34,0x1d,0x34,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,
	0x34,0x1d,0x34,0x34,0x1d,0x1d,0x34,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,0xff,
	0x34,0x1d,0x34,0x1d,0x1d,0x1d,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,
	0x34,0x1d,0x34,0x1d,0x1d,0x1d,0x34,0xff,0x34,0xff,0x34,0xff,0xff,0x34,0xff,0xff,
	0x34,0x1d,0x34,0x1d,0x1d,0x1d,0x34,0xff,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,
	0x34,0x1d,0x34,0x34,0x1d,0x1d,0x34,0xff,0xff,0x34,0xff,0xff,0x34,0xff,0xff,0xff,
	0x34,0x34,0x34,0xff,0x34,0x1d,0x34,0xff,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x34,0x34,0xff,0xff,0xff,0xff,0x34,0xff,0xff,0xff,0xff,
};


// #pragma mark play

const int32 kPlayPauseBitmapWidth = 48;
const int32 kPlayPauseBitmapHeight = 21;
const BPoint kPlayButtonSize(kPlayPauseBitmapWidth - 1, kPlayPauseBitmapHeight - 1);

const unsigned char kPlayButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x11,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,0x12,0x12,0x16,0x19,0x1b,0x1b,
	0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1b,0x19,0x16,0x19,0x1a,
	0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x00,0x00,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x00,0x10,0x1a,0x1a,
	0x00,0x00,0x00,0x10,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1b,
	0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x1c,
	0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1d,
	0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1d,
	0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x3f,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,0x1a,0x1a,
	0x10,0x3f,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x0c,0x19,0x1d,
	0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x12,0x0b,0x10,0x1c,0x1d,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,0x19,0x1e,0x1e,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b
};

const unsigned char kDisabledPlayButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,0x16,0x19,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x16,0x19,0x1b,0x1b,
	0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x1b,
	0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x16,0x16,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x16,0x1b,0x1b,0x1b,
	0x16,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x18,0x1b,
	0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,
	0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x13,0x1b,
	0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x13,0x1b,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,
	0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,
	0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1b,0x1b,
	0x1b,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x18,0x1b,
	0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x1b,
	0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x16,0x19,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,0x16,0x19,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b
};

const unsigned char kPressedPlayButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,0x12,0x14,0x18,0x1a,0x1a,0x1b,
	0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x0f,0x0f,0x13,0x16,0x19,0x1a,
	0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0x18,0x1b,
	0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x00,
	0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x00,0x10,0x13,
	0x13,0x00,0x00,0x00,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,
	0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1c,
	0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x11,0x18,0x1c,
	0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x19,
	0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x10,0x19,0x19,0x19,0x13,
	0x13,0x10,0x19,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x12,0x11,0x11,0x18,0x1b,0x1c,
	0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,0x11,0x16,0x1b,0x1c,0x1d,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0e,0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0e,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b
};

const unsigned char kPlayingPlayButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x11,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,0x12,0x12,0x16,0x19,0x1b,0x1b,
	0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1b,0x19,0x16,0x19,0x1a,
	0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x00,0x00,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x00,0x10,0x1a,0x1a,
	0x00,0x00,0x00,0x10,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1b,
	0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,
	0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,
	0x34,0x34,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x1c,
	0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,
	0x34,0x34,0x34,0x34,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,
	0x34,0x34,0x34,0x34,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1d,
	0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,
	0x34,0x34,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,
	0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1d,
	0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x3f,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,0x1a,0x1a,
	0x10,0x3f,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x0c,0x19,0x1d,
	0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x12,0x0b,0x10,0x1c,0x1d,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,0x19,0x1e,0x1e,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b
};

const unsigned char kPressedPlayingPlayButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,0x12,0x14,0x18,0x1a,0x1a,0x1b,
	0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x0f,0x0f,0x13,0x16,0x19,0x1a,
	0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0x18,0x1b,
	0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x00,
	0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x00,0x10,0x13,
	0x13,0x00,0x00,0x00,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,
	0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x34,0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x34,0x34,0x34,0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1c,
	0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x34,0x34,0x34,0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x34,0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x11,0x18,0x1c,
	0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x19,
	0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x10,0x19,0x19,0x19,0x13,
	0x13,0x10,0x19,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x12,0x11,0x11,0x18,0x1b,0x1c,
	0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,0x11,0x16,0x1b,0x1c,0x1d,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b
};

const unsigned char kPausedPlayButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x11,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,0x12,0x12,0x16,0x19,0x1b,0x1b,
	0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1b,0x19,0x16,0x19,0x1a,
	0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x00,0x00,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x00,0x10,0x1a,0x1a,
	0x00,0x00,0x00,0x10,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1b,
	0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,
	0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,
	0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x1c,
	0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,
	0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,
	0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1d,
	0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,
	0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,
	0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1d,
	0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x3f,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,0x1a,0x1a,
	0x10,0x3f,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x0c,0x19,0x1d,
	0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x12,0x0b,0x10,0x1c,0x1d,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,0x19,0x1e,0x1e,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b
};

const unsigned char kPressedPausedPlayButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,0x12,0x14,0x18,0x1a,0x1a,0x1b,
	0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x0f,0x0f,0x13,0x16,0x19,0x1a,
	0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0x18,0x1b,
	0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x00,
	0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x00,0x10,0x13,
	0x13,0x00,0x00,0x00,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,
	0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,
	0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,
	0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,
	0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1c,
	0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,
	0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,
	0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x11,0x18,0x1c,
	0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,
	0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x19,
	0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x10,0x19,0x19,0x19,0x13,
	0x13,0x10,0x19,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x12,0x11,0x11,0x18,0x1b,0x1c,
	0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,0x11,0x16,0x1b,0x1c,0x1d,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0e,0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b
};

// #pragma mark stop

const int32 kStopBitmapWidth = 31;
const int32 kStopBitmapHeight = 21;
const BPoint kStopButtonSize(kStopBitmapWidth - 1, kStopBitmapHeight - 1);


const unsigned char kStopButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x11,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,0x12,0x12,0x16,0x19,0x1b,0x1b,0x3f,
	0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,0x3f,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1b,0x19,0x16,0x19,0x1a,0x3f,
	0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,0x3f,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x10,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1b,0x3f,
	0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,0x3f,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x1c,0x3f,
	0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,0x3f,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1d,0x3f,
	0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,0x3f,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1d,0x3f,
	0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,0x3f,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x0c,0x19,0x1d,0x3f,
	0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x12,0x0b,0x10,0x1c,0x1d,0x1c,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,0x19,0x1e,0x1e,0x1c,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f
};


const unsigned char kDisabledStopButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x16,0x19,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x1b,0x3f,
	0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x18,0x1b,0x3f,
	0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x3f,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,
	0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x13,0x1b,0x3f,
	0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x13,0x1b,0x3f,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,
	0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x3f,
	0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x18,0x1b,0x3f,
	0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x16,0x19,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f
};


const unsigned char kPressedStopButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,0x12,0x14,0x18,0x1a,0x1a,0x1b,0x3f,
	0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,0x3f,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x0f,0x0f,0x13,0x16,0x19,0x1a,0x3f,
	0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,0x3f,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0x18,0x1b,0x3f,
	0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,0x3f,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,
	0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1c,0x3f,
	0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,0x3f,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x11,0x18,0x1c,0x3f,
	0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,0x3f,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x13,0x13,0x13,0x13,0x12,0x11,0x11,0x18,0x1b,0x1c,0x3f,
	0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,0x3f,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,0x11,0x16,0x1b,0x1c,0x1d,0x1c,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x3f
};

// #pragma mark rewind

const int32 kRewindBitmapWidth = 38;
const int32 kRewindBitmapHeight = 21;
const BPoint kSkipButtonSize(kRewindBitmapWidth - 1, kRewindBitmapHeight - 1);

const unsigned char kRewindBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x11,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,
	0x19,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,
	0x12,0x12,0x16,0x19,0x1b,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,
	0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,0x3f,0x3f,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1b,0x1b,0x19,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x17,0x18,0x1b,0x3f,0x3f,0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,
	0x00,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,0x3f,0x3f,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x17,
	0x17,0x3f,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x12,0x1c,0x3f,0x3f,0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x00,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x00,0x00,0x17,0x17,0x17,
	0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,0x3f,0x3f,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x17,
	0x17,0x3f,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x0f,0x1d,0x3f,0x3f,0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,
	0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,0x3f,0x3f,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,
	0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x18,0x12,0x10,0x1d,0x3f,0x3f,0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,0x3f,0x3f,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x18,0x12,0x0c,0x19,0x1d,0x3f,0x3f,0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,
	0x12,0x0b,0x10,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,
	0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,
	0x19,0x1e,0x1e,0x1c,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};


const unsigned char kDisabledRewindBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,
	0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1a,0x16,0x19,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x16,0x18,0x1b,0x3f,0x3f,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,
	0x16,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x3f,0x3f,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x19,0x19,
	0x19,0x1c,0x1b,0x1b,0x1b,0x16,0x16,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x16,0x16,0x19,0x19,0x19,0x19,0x19,0x1c,0x1b,0x16,0x16,0x19,0x19,0x19,
	0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x13,0x1b,0x3f,0x3f,
	0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x19,0x19,0x19,
	0x19,0x1c,0x1b,0x1c,0x1c,0x19,0x19,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x13,0x1b,0x3f,0x3f,0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,
	0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,
	0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,
	0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x3f,0x3f,0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x18,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x18,0x16,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x16,0x19,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,
	0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};


const unsigned char kPressedRewindBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,
	0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,
	0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,
	0x12,0x14,0x18,0x1a,0x1a,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,
	0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,0x3f,0x3f,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,
	0x0f,0x0f,0x13,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x12,0x0f,0x13,0x18,0x1b,0x3f,0x3f,0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,0x3f,0x3f,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,
	0x00,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x34,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x00,0x00,
	0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x34,0x34,0x34,
	0x34,0x34,0x19,0x13,0x00,0x00,0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x12,0x0f,0x16,0x1c,0x3f,0x3f,0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x19,0x19,0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x19,0x19,0x34,0x34,
	0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,0x3f,0x3f,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x34,
	0x34,0x34,0x19,0x13,0x13,0x13,0x19,0x19,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x11,0x11,0x18,0x1c,0x3f,0x3f,0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x34,0x19,0x13,0x13,0x13,0x13,0x13,
	0x19,0x19,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,0x3f,0x3f,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,
	0x12,0x11,0x11,0x18,0x1b,0x1c,0x3f,0x3f,0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,
	0x11,0x16,0x1b,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,
	0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};

const unsigned char kForwardBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x11,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,
	0x19,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,
	0x12,0x12,0x16,0x19,0x1b,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,
	0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,0x3f,0x3f,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1b,0x1b,0x19,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x17,0x18,0x1b,0x3f,0x3f,0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x00,
	0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,0x3f,0x3f,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x00,0x00,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x12,0x1c,0x3f,0x3f,0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x00,0x00,0x1a,0x00,0x17,0x17,
	0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,0x3f,0x3f,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x3f,0x3f,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x0f,0x1d,0x3f,0x3f,0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x00,0x17,0x17,
	0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,0x3f,0x3f,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x3f,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x18,0x12,0x10,0x1d,0x3f,0x3f,0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,0x3f,0x3f,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x18,0x12,0x0c,0x19,0x1d,0x3f,0x3f,0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,
	0x12,0x0b,0x10,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,
	0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,
	0x19,0x1e,0x1e,0x1c,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};

const unsigned char kDisabledForwardBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,
	0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1a,0x16,0x19,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x16,0x18,0x1b,0x3f,0x3f,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x16,
	0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x3f,0x3f,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x16,0x16,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x16,0x16,0x1b,0x16,0x19,0x19,
	0x19,0x19,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x13,0x1b,0x3f,0x3f,
	0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x1c,0x1c,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x13,0x1b,0x3f,0x3f,0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x16,0x19,0x19,
	0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,
	0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x3f,0x3f,0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x18,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x18,0x16,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x16,0x19,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,
	0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};

const unsigned char kPressedForwardBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,
	0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,
	0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,
	0x12,0x14,0x18,0x1a,0x1a,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,
	0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,0x3f,0x3f,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,
	0x0f,0x0f,0x13,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x12,0x0f,0x13,0x18,0x1b,0x3f,0x3f,0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,0x3f,0x3f,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x00,
	0x00,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x00,0x00,0x13,0x13,0x13,0x00,0x34,
	0x34,0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x34,0x34,0x00,0x00,0x13,0x00,0x34,0x34,0x34,0x34,0x34,0x00,0x00,0x13,0x13,
	0x13,0x13,0x12,0x0f,0x16,0x1c,0x3f,0x3f,0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x34,0x34,0x19,0x19,0x13,0x00,0x34,
	0x34,0x34,0x34,0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,0x3f,0x3f,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x19,0x19,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x19,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x11,0x11,0x18,0x1c,0x3f,0x3f,0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x34,
	0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,0x3f,0x3f,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x12,0x11,0x11,0x18,0x1b,0x1c,0x3f,0x3f,0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,
	0x11,0x16,0x1b,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,
	0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};


// #pragma mark skip back

const unsigned char kSkipBackBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,
	0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,
	0x12,0x12,0x16,0x19,0x1b,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,
	0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,0x3f,0x3f,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1b,0x1b,0x19,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x17,0x18,0x1b,0x3f,0x3f,0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,
	0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x00,0x00,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,0x3f,0x3f,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x00,0x00,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x12,0x1c,0x3f,0x3f,0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x00,0x3f,0x1a,0x00,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x00,0x00,0x17,
	0x17,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,0x3f,0x3f,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x3f,0x3f,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x0f,0x1d,0x3f,0x3f,0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x3f,
	0x3f,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,0x3f,0x3f,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x3f,0x3f,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x18,0x12,0x10,0x1d,0x3f,0x3f,0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,0x3f,0x3f,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x18,0x12,0x0c,0x19,0x1d,0x3f,0x3f,0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,
	0x12,0x0b,0x10,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,
	0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,
	0x19,0x1e,0x1e,0x1c,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};

const unsigned char kDisabledSkipBackBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x16,
	0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
	0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x18,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x18,0x15,0x15,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x15,
	0x15,0x18,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x18,0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x19,0x16,0x18,0x1b,0x1b,0x3f,0x3f,0x1b,0x1a,0x15,0x18,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x15,0x1a,0x1b,0x3f,0x3f,
	0x1b,0x18,0x15,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x15,0x18,0x1b,0x3f,0x3f,0x1b,0x16,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x16,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x17,0x16,0x1b,0x3f,0x3f,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x16,0x16,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x16,0x16,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,0x1b,0x13,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x1c,0x1b,0x16,0x16,0x19,0x19,0x19,0x19,0x19,0x1c,0x1b,0x16,0x16,0x19,
	0x19,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x13,0x1b,0x3f,0x3f,
	0x1b,0x13,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1c,0x1c,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1c,0x1c,0x19,0x19,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x13,0x1b,0x3f,0x3f,0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1c,
	0x1c,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,
	0x1b,0x16,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1c,0x1c,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x17,0x16,0x1b,0x3f,0x3f,0x1b,0x18,0x15,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x15,0x18,0x1b,0x3f,0x3f,
	0x1b,0x1a,0x15,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x18,0x15,0x1a,0x1b,0x3f,0x3f,0x1b,0x1b,0x18,0x16,0x19,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x18,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x18,0x15,0x15,0x17,
	0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x15,0x15,0x18,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
	0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x18,
	0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};


const unsigned char kPressedSkipBackBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,
	0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,
	0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,
	0x12,0x14,0x18,0x1a,0x1a,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,
	0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,0x3f,0x3f,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,
	0x0f,0x0f,0x13,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x12,0x0f,0x13,0x18,0x1b,0x3f,0x3f,0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,0x3f,0x3f,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x13,
	0x13,0x00,0x00,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x34,0x19,0x13,0x13,
	0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x00,0x00,0x34,0x34,0x34,0x19,0x13,0x13,0x13,
	0x00,0x00,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x00,0x00,0x34,
	0x34,0x34,0x34,0x34,0x19,0x13,0x00,0x00,0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x13,
	0x13,0x13,0x12,0x0f,0x16,0x1c,0x3f,0x3f,0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x19,0x13,0x19,0x19,0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x19,0x19,
	0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,0x3f,0x3f,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x19,
	0x19,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x19,0x19,0x34,0x34,0x34,0x19,0x13,0x13,
	0x13,0x13,0x11,0x11,0x18,0x1c,0x3f,0x3f,0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,
	0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x34,0x19,0x13,0x13,0x13,
	0x13,0x13,0x19,0x19,0x34,0x19,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,0x3f,0x3f,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,
	0x12,0x11,0x11,0x18,0x1b,0x1c,0x3f,0x3f,0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,
	0x11,0x16,0x1b,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,
	0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};

// #pragma mark skip forward

const unsigned char kSkipForwardBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,
	0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,
	0x12,0x12,0x16,0x19,0x1b,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,
	0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,0x3f,0x3f,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1b,0x1b,0x19,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x17,0x18,0x1b,0x3f,0x3f,0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,
	0x1a,0x00,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x00,0x00,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,0x3f,0x3f,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x00,0x00,0x1a,
	0x1a,0x1a,0x00,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x12,0x1c,0x3f,0x3f,0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x00,0x00,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,
	0x00,0x00,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,0x3f,0x3f,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,
	0x3f,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x0f,0x1d,0x3f,0x3f,0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x00,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x3f,0x3f,
	0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,0x3f,0x3f,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x00,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x18,0x12,0x10,0x1d,0x3f,0x3f,0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,0x3f,0x3f,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x18,0x12,0x0c,0x19,0x1d,0x3f,0x3f,0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,
	0x12,0x0b,0x10,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,
	0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,
	0x19,0x1e,0x1e,0x1c,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};


const unsigned char kDisabledSkipForwardBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x16,
	0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
	0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x18,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x18,0x15,0x15,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x15,
	0x15,0x18,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x18,0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x19,0x16,0x18,0x1b,0x1b,0x3f,0x3f,0x1b,0x1a,0x15,0x18,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x15,0x1a,0x1b,0x3f,0x3f,
	0x1b,0x18,0x15,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x15,0x18,0x1b,0x3f,0x3f,0x1b,0x16,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x16,0x16,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x17,0x16,0x1b,0x3f,0x3f,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x16,0x16,0x1b,
	0x1b,0x1b,0x16,0x19,0x19,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,0x1b,0x13,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x16,0x16,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,
	0x16,0x16,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x13,0x1b,0x3f,0x3f,
	0x1b,0x13,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x1c,
	0x1c,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x1c,0x1c,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x13,0x1b,0x3f,0x3f,0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x19,0x19,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,
	0x1b,0x16,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x16,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x17,0x16,0x1b,0x3f,0x3f,0x1b,0x18,0x15,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x15,0x18,0x1b,0x3f,0x3f,
	0x1b,0x1a,0x15,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x18,0x15,0x1a,0x1b,0x3f,0x3f,0x1b,0x1b,0x18,0x16,0x19,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x18,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x18,0x15,0x15,0x17,
	0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x15,0x15,0x18,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
	0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x18,
	0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};


const unsigned char kPressedSkipForwardBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,
	0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,
	0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,
	0x12,0x14,0x18,0x1a,0x1a,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,
	0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,0x3f,0x3f,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,
	0x0f,0x0f,0x13,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x12,0x0f,0x13,0x18,0x1b,0x3f,0x3f,0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,0x3f,0x3f,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x00,0x00,0x13,0x13,
	0x13,0x13,0x13,0x00,0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x13,
	0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x34,0x34,0x34,0x00,0x00,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x00,
	0x00,0x13,0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x34,0x34,
	0x00,0x00,0x13,0x00,0x34,0x34,0x34,0x34,0x34,0x00,0x00,0x13,0x00,0x19,0x13,0x13,
	0x13,0x13,0x12,0x0f,0x16,0x1c,0x3f,0x3f,0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x34,0x34,0x34,0x34,0x34,0x19,0x19,0x13,0x00,0x34,0x34,0x34,0x34,
	0x34,0x19,0x19,0x13,0x00,0x19,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,0x3f,0x3f,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x19,0x19,
	0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x19,0x19,0x13,0x13,0x13,0x00,0x19,0x13,0x13,
	0x13,0x13,0x11,0x11,0x18,0x1c,0x3f,0x3f,0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,
	0x13,0x13,0x00,0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x19,0x19,0x13,
	0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,0x3f,0x3f,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,
	0x12,0x11,0x11,0x18,0x1b,0x1c,0x3f,0x3f,0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,
	0x11,0x16,0x1b,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,
	0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};

// #pragma mark volumn slider
const int32 kVolumeSliderBitmapWidth = 6;
const int32 kVolumeSliderBitmapHeight = 15;
const BPoint kVolumeSliderBitmapSize(kVolumeSliderBitmapWidth - 1,
									 kVolumeSliderBitmapHeight - 1);

const unsigned char kVolumeSliderLeftBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x19,0x19,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x18,0x11,0x0b,0x3f,0x3f,
	0x1b,0x19,0x15,0x0b,0x06,0x0a,0x3f,0x3f,
	0x1a,0x15,0x09,0x09,0xb6,0x8f,0x3f,0x3f,
	0x18,0x0b,0x09,0x8f,0x8f,0x8f,0x3f,0x3f,
	0x11,0x07,0xb6,0x8f,0x8f,0x68,0x3f,0x3f,
	0x0c,0x0c,0x8f,0x8f,0x68,0x68,0x3f,0x3f,
	0x07,0x10,0x8f,0x68,0x68,0x68,0x3f,0x3f,
	0x16,0x12,0x8f,0x68,0x68,0x68,0x3f,0x3f,
	0x1a,0x16,0x11,0x68,0x68,0x68,0x3f,0x3f,
	0x1b,0x1a,0x18,0x68,0x68,0x68,0x3f,0x3f,
	0x1b,0x1b,0x1c,0x19,0x68,0x68,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1d,0x1c,0x19,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1d,0x1e,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x3f,0x3f
};

const unsigned char kVolumeSliderRightBits [] = {
	0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x11,0x18,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x08,0x0d,0x16,0x1a,0x1b,0x1b,0x3f,0x3f,
	0x11,0x0c,0x0f,0x17,0x1a,0x1b,0x3f,0x3f,
	0x13,0x13,0x10,0x14,0x19,0x1b,0x3f,0x3f,
	0x13,0x13,0x13,0x15,0x19,0x1a,0x3f,0x3f,
	0x13,0x13,0x13,0x16,0x1a,0x1a,0x3f,0x3f,
	0x13,0x13,0x13,0x15,0x1c,0x1b,0x3f,0x3f,
	0x13,0x13,0x13,0x19,0x1e,0x1c,0x3f,0x3f,
	0x13,0x13,0x15,0x1d,0x1d,0x1c,0x3f,0x3f,
	0x13,0x14,0x1a,0x1e,0x1c,0x1b,0x3f,0x3f,
	0x15,0x1b,0x3f,0x1d,0x1b,0x1b,0x3f,0x3f,
	0x1d,0x1e,0x1d,0x1c,0x1b,0x1b,0x3f,0x3f,
	0x1d,0x1c,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};

const int32 kVolumeSliderKnobWidth = 11;
const int32 kVolumeSliderKnobHeight = 11;
const BPoint kVolumeSliderKnobBitmapSize(kVolumeSliderKnobWidth - 1, kVolumeSliderKnobHeight - 1);

const unsigned char kVolumeSliderKnobBits [] = {
	0x00,0x00,0x13,0x18,0x1d,0x3f,0x1d,0x19,0x12,0x00,0x00,0x3f,
	0x00,0x15,0x1d,0x1e,0x1e,0x1d,0x1e,0x1b,0x19,0x12,0x00,0x3f,
	0x00,0x1e,0x1e,0x1d,0x1d,0x3f,0x1d,0x1d,0x1b,0x19,0x00,0x3f,
	0x1a,0x1e,0x1d,0x1d,0x1d,0x13,0x1d,0x1d,0x1d,0x19,0x12,0x3f,
	0x1e,0x1e,0x1d,0x1d,0x1d,0x3f,0x1d,0x1d,0x1d,0x19,0x11,0x3f,
	0x3f,0x1d,0x1d,0x1d,0x1d,0x13,0x1d,0x1d,0x1d,0x1c,0x0e,0x3f,
	0x1e,0x1e,0x1d,0x1d,0x1d,0x3f,0x1d,0x1d,0x1d,0x19,0x11,0x3f,
	0x1a,0x1d,0x1d,0x1d,0x1d,0x13,0x1d,0x1d,0x1d,0x15,0x00,0x3f,
	0x00,0x1a,0x19,0x1d,0x1d,0x1d,0x1d,0x1d,0x17,0x12,0x00,0x3f,
	0x00,0x16,0x13,0x15,0x19,0x1c,0x19,0x15,0x12,0x00,0x00,0x3f,
	0x00,0x00,0x00,0x14,0x11,0x0e,0x11,0x14,0x00,0x00,0x00,0x3f
};

#endif	// BEOS_BITMAPS_H
