/*******************************************************************************
* telnet.h: Telnet class definition
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: telnet.h,v 1.2 2001/11/03 18:09:08 asmax Exp $
*
* Authors: Benoit Steiner <benny@via.ecp.fr>
*          Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


#ifndef _TELNET_H_
#define _TELNET_H_


//------------------------------------------------------------------------------
// E_Telnet class
//------------------------------------------------------------------------------
class E_Telnet : public E_Exception
{
 public:
  E_Telnet(const C_String& strMsg);
  E_Telnet(const C_String& strMsg, const E_Exception& e);
};


//------------------------------------------------------------------------------
// C_TelnetOptions class
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
class C_TelnetOptions
{
 public:
  C_Buffer<byte> Request(byte bAction, byte bOption);
  C_Buffer<byte> Answer(const C_Buffer<byte>& cRequest);
  int GetOptionStatus();

 private:
  // Local NVT settings
  bool m_bLocalEcho;
  bool m_bLocalSGA;
  bool m_bLocalLineMode;

  // Remote NVT settings
  bool m_bRemoteEcho;
  bool m_bRemoteSGA;
  bool m_bRemoteLineMode;

  // Pending negociations
  C_List< C_Buffer<byte> > m_cPendingRequests;
};


/*//------------------------------------------------------------------------------
// C_TelnetLogin class
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
class C_TelnetLogin
{
 public:  
  C_TelnetLogin();

  const C_String& GetLogin() const;
  void SetLogin(const C_String& strLogin);
  void ResetLogin();
  
  bool IsLoginSet() const;

 private:
  C_String m_strLogin;
  bool m_bLoginSet;
};*/



//------------------------------------------------------------------------------
// C_TelnetCmdLine class
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
class C_TelnetCmdLine
{
 public:
  // Constructor
  C_TelnetCmdLine();
  
  // Local and remote command line construction
  C_Buffer<byte> Edit(const C_Buffer<byte>& cCmd);
  C_String Append(byte bByte);

  // Local command line storage
  void StartNewLine();
  void DropLine();
  
  // Cmd line retrieval
  C_String GetCmdLine();

 private:
  // Current command line
  C_String m_strLine;
  unsigned int m_iPosInLine;
  
  // Command line history
  C_List<C_String> m_cHistory;
  C_ListIterator<C_String> m_cCurrent;
};


//------------------------------------------------------------------------------
// C_TelnetSession class
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
class C_TelnetSession : public C_AdminSession
{
 public:
  C_TelnetSession(C_Socket* pConnection, void* pAdmin);

  // Data processing
  void ProcessData();

  C_String m_strPeerName;

 protected:
  virtual void OnInit();
  virtual void OnClose();

  void HandleByte(byte bChar);
  void HandleLine();

  void ExecLogin();
  void ExecCommand();
  
  void SendAnswer(const C_Answer& cAnswer, const C_String& strPrefix = "");
  
 private:
  // Connection to the peer
  C_Socket* m_pConnection;
  C_Stream<C_Socket> m_cStream;

  // Session status
  int m_iMode;
  int m_iPhase;

  // Internal data
  C_String m_strPrompt;
  C_String m_strLogin;
  C_TelnetCmdLine m_cCmdLine;
  C_TelnetOptions m_cOptions;
  C_Buffer<byte> m_cBuffer;
};



//------------------------------------------------------------------------------
// C_Telnet class
//------------------------------------------------------------------------------
class C_Telnet : protected C_ConnectionsHandler<C_TelnetSession>
{
 public:
  C_Telnet(handle hLog, C_Admin* pAdmin);
  
  int Init();
  int Run();
  int Stop();
  int Destroy();

 private:
  // Helpers
  handle m_hLog;
  C_Admin* m_pAdmin;

};



#else
#error "Multiple inclusions of telnet.h"
#endif

